@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin

import com.pulumi.aws.organizations.OrganizationalUnitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to create an organizational unit.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.OrganizationalUnit;
 * import com.pulumi.aws.organizations.OrganizationalUnitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OrganizationalUnit("example", OrganizationalUnitArgs.builder()
 *             .parentId(aws_organizations_organization.example().roots()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Organizations Organizational Units using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:organizations/organizationalUnit:OrganizationalUnit example ou-1234567
 * ```
 * @property name The name for the organizational unit
 * @property parentId ID of the parent organizational unit, which may be the root
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class OrganizationalUnitArgs(
    public val name: Output<String>? = null,
    public val parentId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.organizations.OrganizationalUnitArgs> {
    override fun toJava(): com.pulumi.aws.organizations.OrganizationalUnitArgs =
        com.pulumi.aws.organizations.OrganizationalUnitArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .parentId(parentId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [OrganizationalUnitArgs].
 */
@PulumiTagMarker
public class OrganizationalUnitArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parentId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name for the organizational unit
     */
    @JvmName("fkiryijaedfvwefr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ID of the parent organizational unit, which may be the root
     */
    @JvmName("odehjhrppsmwfyws")
    public suspend fun parentId(`value`: Output<String>) {
        this.parentId = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lqsptvaqpsyclser")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name for the organizational unit
     */
    @JvmName("rrconbodnasgkjvc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ID of the parent organizational unit, which may be the root
     */
    @JvmName("ignpsndbdqnogokn")
    public suspend fun parentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentId = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lfhijvhsgrfmoayy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fexlbalkjtlbhpke")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): OrganizationalUnitArgs = OrganizationalUnitArgs(
        name = name,
        parentId = parentId,
        tags = tags,
    )
}
