@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin

import com.pulumi.aws.organizations.OrganizationsFunctions.getDelegatedAdministratorsPlain
import com.pulumi.aws.organizations.OrganizationsFunctions.getDelegatedServicesPlain
import com.pulumi.aws.organizations.OrganizationsFunctions.getOrganizationPlain
import com.pulumi.aws.organizations.OrganizationsFunctions.getOrganizationalUnitChildAccountsPlain
import com.pulumi.aws.organizations.OrganizationsFunctions.getOrganizationalUnitDescendantAccountsPlain
import com.pulumi.aws.organizations.OrganizationsFunctions.getOrganizationalUnitPlain
import com.pulumi.aws.organizations.OrganizationsFunctions.getOrganizationalUnitsPlain
import com.pulumi.aws.organizations.OrganizationsFunctions.getPoliciesForTargetPlain
import com.pulumi.aws.organizations.OrganizationsFunctions.getPoliciesPlain
import com.pulumi.aws.organizations.OrganizationsFunctions.getPolicyPlain
import com.pulumi.aws.organizations.OrganizationsFunctions.getResourceTagsPlain
import com.pulumi.aws.organizations.kotlin.inputs.GetDelegatedAdministratorsPlainArgs
import com.pulumi.aws.organizations.kotlin.inputs.GetDelegatedAdministratorsPlainArgsBuilder
import com.pulumi.aws.organizations.kotlin.inputs.GetDelegatedServicesPlainArgs
import com.pulumi.aws.organizations.kotlin.inputs.GetDelegatedServicesPlainArgsBuilder
import com.pulumi.aws.organizations.kotlin.inputs.GetOrganizationalUnitChildAccountsPlainArgs
import com.pulumi.aws.organizations.kotlin.inputs.GetOrganizationalUnitChildAccountsPlainArgsBuilder
import com.pulumi.aws.organizations.kotlin.inputs.GetOrganizationalUnitDescendantAccountsPlainArgs
import com.pulumi.aws.organizations.kotlin.inputs.GetOrganizationalUnitDescendantAccountsPlainArgsBuilder
import com.pulumi.aws.organizations.kotlin.inputs.GetOrganizationalUnitPlainArgs
import com.pulumi.aws.organizations.kotlin.inputs.GetOrganizationalUnitPlainArgsBuilder
import com.pulumi.aws.organizations.kotlin.inputs.GetOrganizationalUnitsPlainArgs
import com.pulumi.aws.organizations.kotlin.inputs.GetOrganizationalUnitsPlainArgsBuilder
import com.pulumi.aws.organizations.kotlin.inputs.GetPoliciesForTargetPlainArgs
import com.pulumi.aws.organizations.kotlin.inputs.GetPoliciesForTargetPlainArgsBuilder
import com.pulumi.aws.organizations.kotlin.inputs.GetPoliciesPlainArgs
import com.pulumi.aws.organizations.kotlin.inputs.GetPoliciesPlainArgsBuilder
import com.pulumi.aws.organizations.kotlin.inputs.GetPolicyPlainArgs
import com.pulumi.aws.organizations.kotlin.inputs.GetPolicyPlainArgsBuilder
import com.pulumi.aws.organizations.kotlin.inputs.GetResourceTagsPlainArgs
import com.pulumi.aws.organizations.kotlin.inputs.GetResourceTagsPlainArgsBuilder
import com.pulumi.aws.organizations.kotlin.outputs.GetDelegatedAdministratorsResult
import com.pulumi.aws.organizations.kotlin.outputs.GetDelegatedServicesResult
import com.pulumi.aws.organizations.kotlin.outputs.GetOrganizationResult
import com.pulumi.aws.organizations.kotlin.outputs.GetOrganizationalUnitChildAccountsResult
import com.pulumi.aws.organizations.kotlin.outputs.GetOrganizationalUnitDescendantAccountsResult
import com.pulumi.aws.organizations.kotlin.outputs.GetOrganizationalUnitResult
import com.pulumi.aws.organizations.kotlin.outputs.GetOrganizationalUnitsResult
import com.pulumi.aws.organizations.kotlin.outputs.GetPoliciesForTargetResult
import com.pulumi.aws.organizations.kotlin.outputs.GetPoliciesResult
import com.pulumi.aws.organizations.kotlin.outputs.GetPolicyResult
import com.pulumi.aws.organizations.kotlin.outputs.GetResourceTagsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.organizations.kotlin.outputs.GetDelegatedAdministratorsResult.Companion.toKotlin as getDelegatedAdministratorsResultToKotlin
import com.pulumi.aws.organizations.kotlin.outputs.GetDelegatedServicesResult.Companion.toKotlin as getDelegatedServicesResultToKotlin
import com.pulumi.aws.organizations.kotlin.outputs.GetOrganizationResult.Companion.toKotlin as getOrganizationResultToKotlin
import com.pulumi.aws.organizations.kotlin.outputs.GetOrganizationalUnitChildAccountsResult.Companion.toKotlin as getOrganizationalUnitChildAccountsResultToKotlin
import com.pulumi.aws.organizations.kotlin.outputs.GetOrganizationalUnitDescendantAccountsResult.Companion.toKotlin as getOrganizationalUnitDescendantAccountsResultToKotlin
import com.pulumi.aws.organizations.kotlin.outputs.GetOrganizationalUnitResult.Companion.toKotlin as getOrganizationalUnitResultToKotlin
import com.pulumi.aws.organizations.kotlin.outputs.GetOrganizationalUnitsResult.Companion.toKotlin as getOrganizationalUnitsResultToKotlin
import com.pulumi.aws.organizations.kotlin.outputs.GetPoliciesForTargetResult.Companion.toKotlin as getPoliciesForTargetResultToKotlin
import com.pulumi.aws.organizations.kotlin.outputs.GetPoliciesResult.Companion.toKotlin as getPoliciesResultToKotlin
import com.pulumi.aws.organizations.kotlin.outputs.GetPolicyResult.Companion.toKotlin as getPolicyResultToKotlin
import com.pulumi.aws.organizations.kotlin.outputs.GetResourceTagsResult.Companion.toKotlin as getResourceTagsResultToKotlin

public object OrganizationsFunctions {
    /**
     * Get a list of AWS accounts that are designated as delegated administrators in this organization
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.organizations.OrganizationsFunctions;
     * import com.pulumi.aws.organizations.inputs.GetDelegatedAdministratorsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OrganizationsFunctions.getDelegatedAdministrators(GetDelegatedAdministratorsArgs.builder()
     *             .servicePrincipal("SERVICE PRINCIPAL")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDelegatedAdministrators.
     * @return A collection of values returned by getDelegatedAdministrators.
     */
    public suspend fun getDelegatedAdministrators(argument: GetDelegatedAdministratorsPlainArgs):
        GetDelegatedAdministratorsResult =
        getDelegatedAdministratorsResultToKotlin(getDelegatedAdministratorsPlain(argument.toJava()).await())

    /**
     * @see [getDelegatedAdministrators].
     * @param servicePrincipal Specifies a service principal name. If specified, then the operation lists the delegated administrators only for the specified service. If you don't specify a service principal, the operation lists all delegated administrators for all services in your organization.
     * @return A collection of values returned by getDelegatedAdministrators.
     */
    public suspend fun getDelegatedAdministrators(servicePrincipal: String? = null):
        GetDelegatedAdministratorsResult {
        val argument = GetDelegatedAdministratorsPlainArgs(
            servicePrincipal = servicePrincipal,
        )
        return getDelegatedAdministratorsResultToKotlin(getDelegatedAdministratorsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDelegatedAdministrators].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;organizations&#46;kotlin&#46;inputs&#46;GetDelegatedAdministratorsPlainArgs].
     * @return A collection of values returned by getDelegatedAdministrators.
     */
    public suspend
    fun getDelegatedAdministrators(argument: suspend GetDelegatedAdministratorsPlainArgsBuilder.() -> Unit):
        GetDelegatedAdministratorsResult {
        val builder = GetDelegatedAdministratorsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDelegatedAdministratorsResultToKotlin(getDelegatedAdministratorsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a list the AWS services for which the specified account is a delegated administrator
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.organizations.OrganizationsFunctions;
     * import com.pulumi.aws.organizations.inputs.GetDelegatedServicesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OrganizationsFunctions.getDelegatedServices(GetDelegatedServicesArgs.builder()
     *             .accountId("AWS ACCOUNT ID")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDelegatedServices.
     * @return A collection of values returned by getDelegatedServices.
     */
    public suspend fun getDelegatedServices(argument: GetDelegatedServicesPlainArgs):
        GetDelegatedServicesResult =
        getDelegatedServicesResultToKotlin(getDelegatedServicesPlain(argument.toJava()).await())

    /**
     * @see [getDelegatedServices].
     * @param accountId Account ID number of a delegated administrator account in the organization.
     * @return A collection of values returned by getDelegatedServices.
     */
    public suspend fun getDelegatedServices(accountId: String): GetDelegatedServicesResult {
        val argument = GetDelegatedServicesPlainArgs(
            accountId = accountId,
        )
        return getDelegatedServicesResultToKotlin(getDelegatedServicesPlain(argument.toJava()).await())
    }

    /**
     * @see [getDelegatedServices].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;organizations&#46;kotlin&#46;inputs&#46;GetDelegatedServicesPlainArgs].
     * @return A collection of values returned by getDelegatedServices.
     */
    public suspend
    fun getDelegatedServices(argument: suspend GetDelegatedServicesPlainArgsBuilder.() -> Unit):
        GetDelegatedServicesResult {
        val builder = GetDelegatedServicesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDelegatedServicesResultToKotlin(getDelegatedServicesPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information about the organization that the user's account belongs to
     * ## Example Usage
     * ### List all account IDs for the organization
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.organizations.OrganizationsFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OrganizationsFunctions.getOrganization();
     *         ctx.export("accountIds", example.applyValue(getOrganizationResult -> getOrganizationResult.accounts()).stream().map(element -> element.id()).collect(toList()));
     *     }
     * }
     * ```
     * ### SNS topic that can be interacted by the organization only
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.organizations.OrganizationsFunctions;
     * import com.pulumi.aws.sns.Topic;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.sns.TopicPolicy;
     * import com.pulumi.aws.sns.TopicPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OrganizationsFunctions.getOrganization();
     *         var snsTopic = new Topic("snsTopic");
     *         final var snsTopicPolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .effect("Allow")
     *                 .actions(
     *                     "SNS:Subscribe",
     *                     "SNS:Publish")
     *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
     *                     .test("StringEquals")
     *                     .variable("aws:PrincipalOrgID")
     *                     .values(example.applyValue(getOrganizationResult -> getOrganizationResult.id()))
     *                     .build())
     *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                     .type("AWS")
     *                     .identifiers("*")
     *                     .build())
     *                 .resources(snsTopic.arn())
     *                 .build())
     *             .build());
     *         var snsTopicPolicyTopicPolicy = new TopicPolicy("snsTopicPolicyTopicPolicy", TopicPolicyArgs.builder()
     *             .arn(snsTopic.arn())
     *             .policy(snsTopicPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(snsTopicPolicyPolicyDocument -> snsTopicPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
     *             .build());
     *     }
     * }
     * ```
     * ### List all account IDs for the organization
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.organizations.OrganizationsFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OrganizationsFunctions.getOrganization();
     *         ctx.export("accountIds", example.applyValue(getOrganizationResult -> getOrganizationResult.accounts()).stream().map(element -> element.id()).collect(toList()));
     *     }
     * }
     * ```
     * ### SNS topic that can be interacted by the organization only
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.organizations.OrganizationsFunctions;
     * import com.pulumi.aws.sns.Topic;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.sns.TopicPolicy;
     * import com.pulumi.aws.sns.TopicPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OrganizationsFunctions.getOrganization();
     *         var snsTopic = new Topic("snsTopic");
     *         final var snsTopicPolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .effect("Allow")
     *                 .actions(
     *                     "SNS:Subscribe",
     *                     "SNS:Publish")
     *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
     *                     .test("StringEquals")
     *                     .variable("aws:PrincipalOrgID")
     *                     .values(example.applyValue(getOrganizationResult -> getOrganizationResult.id()))
     *                     .build())
     *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                     .type("AWS")
     *                     .identifiers("*")
     *                     .build())
     *                 .resources(snsTopic.arn())
     *                 .build())
     *             .build());
     *         var snsTopicPolicyTopicPolicy = new TopicPolicy("snsTopicPolicyTopicPolicy", TopicPolicyArgs.builder()
     *             .arn(snsTopic.arn())
     *             .policy(snsTopicPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(snsTopicPolicyPolicyDocument -> snsTopicPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
     *             .build());
     *     }
     * }
     * ```
     * @param argument Get information about the organization that the user's account belongs to
     * ## Example Usage
     * ### List all account IDs for the organization
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.organizations.OrganizationsFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OrganizationsFunctions.getOrganization();
     *         ctx.export("accountIds", example.applyValue(getOrganizationResult -> getOrganizationResult.accounts()).stream().map(element -> element.id()).collect(toList()));
     *     }
     * }
     * ```
     * ### SNS topic that can be interacted by the organization only
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.organizations.OrganizationsFunctions;
     * import com.pulumi.aws.sns.Topic;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.sns.TopicPolicy;
     * import com.pulumi.aws.sns.TopicPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OrganizationsFunctions.getOrganization();
     *         var snsTopic = new Topic("snsTopic");
     *         final var snsTopicPolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .effect("Allow")
     *                 .actions(
     *                     "SNS:Subscribe",
     *                     "SNS:Publish")
     *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
     *                     .test("StringEquals")
     *                     .variable("aws:PrincipalOrgID")
     *                     .values(example.applyValue(getOrganizationResult -> getOrganizationResult.id()))
     *                     .build())
     *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                     .type("AWS")
     *                     .identifiers("*")
     *                     .build())
     *                 .resources(snsTopic.arn())
     *                 .build())
     *             .build());
     *         var snsTopicPolicyTopicPolicy = new TopicPolicy("snsTopicPolicyTopicPolicy", TopicPolicyArgs.builder()
     *             .arn(snsTopic.arn())
     *             .policy(snsTopicPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(snsTopicPolicyPolicyDocument -> snsTopicPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
     *             .build());
     *     }
     * }
     * ```
     * ### List all account IDs for the organization
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.organizations.OrganizationsFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OrganizationsFunctions.getOrganization();
     *         ctx.export("accountIds", example.applyValue(getOrganizationResult -> getOrganizationResult.accounts()).stream().map(element -> element.id()).collect(toList()));
     *     }
     * }
     * ```
     * ### SNS topic that can be interacted by the organization only
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.organizations.OrganizationsFunctions;
     * import com.pulumi.aws.sns.Topic;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.sns.TopicPolicy;
     * import com.pulumi.aws.sns.TopicPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OrganizationsFunctions.getOrganization();
     *         var snsTopic = new Topic("snsTopic");
     *         final var snsTopicPolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .effect("Allow")
     *                 .actions(
     *                     "SNS:Subscribe",
     *                     "SNS:Publish")
     *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
     *                     .test("StringEquals")
     *                     .variable("aws:PrincipalOrgID")
     *                     .values(example.applyValue(getOrganizationResult -> getOrganizationResult.id()))
     *                     .build())
     *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                     .type("AWS")
     *                     .identifiers("*")
     *                     .build())
     *                 .resources(snsTopic.arn())
     *                 .build())
     *             .build());
     *         var snsTopicPolicyTopicPolicy = new TopicPolicy("snsTopicPolicyTopicPolicy", TopicPolicyArgs.builder()
     *             .arn(snsTopic.arn())
     *             .policy(snsTopicPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(snsTopicPolicyPolicyDocument -> snsTopicPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
     *             .build());
     *     }
     * }
     * ```
     * @return A collection of values returned by getOrganization.
     */
    public suspend fun getOrganization(): GetOrganizationResult =
        getOrganizationResultToKotlin(getOrganizationPlain().await())

    /**
     * Data source for getting an AWS Organizations Organizational Unit.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.organizations.OrganizationsFunctions;
     * import com.pulumi.aws.organizations.inputs.GetOrganizationalUnitArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var org = OrganizationsFunctions.getOrganization();
     *         final var ou = OrganizationsFunctions.getOrganizationalUnit(GetOrganizationalUnitArgs.builder()
     *             .parentId(org.applyValue(getOrganizationResult -> getOrganizationResult.roots()[0].id()))
     *             .name("dev")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getOrganizationalUnit.
     * @return A collection of values returned by getOrganizationalUnit.
     */
    public suspend fun getOrganizationalUnit(argument: GetOrganizationalUnitPlainArgs):
        GetOrganizationalUnitResult =
        getOrganizationalUnitResultToKotlin(getOrganizationalUnitPlain(argument.toJava()).await())

    /**
     * @see [getOrganizationalUnit].
     * @param name Name of the organizational unit
     * @param parentId Parent ID of the organizational unit.
     * @return A collection of values returned by getOrganizationalUnit.
     */
    public suspend fun getOrganizationalUnit(name: String, parentId: String):
        GetOrganizationalUnitResult {
        val argument = GetOrganizationalUnitPlainArgs(
            name = name,
            parentId = parentId,
        )
        return getOrganizationalUnitResultToKotlin(getOrganizationalUnitPlain(argument.toJava()).await())
    }

    /**
     * @see [getOrganizationalUnit].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;organizations&#46;kotlin&#46;inputs&#46;GetOrganizationalUnitPlainArgs].
     * @return A collection of values returned by getOrganizationalUnit.
     */
    public suspend
    fun getOrganizationalUnit(argument: suspend GetOrganizationalUnitPlainArgsBuilder.() -> Unit):
        GetOrganizationalUnitResult {
        val builder = GetOrganizationalUnitPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrganizationalUnitResultToKotlin(getOrganizationalUnitPlain(builtArgument.toJava()).await())
    }

    /**
     * Get all direct child accounts under a parent organizational unit. This only provides immediate children, not all children.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.organizations.OrganizationsFunctions;
     * import com.pulumi.aws.organizations.inputs.GetOrganizationalUnitChildAccountsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var org = OrganizationsFunctions.getOrganization();
     *         final var accounts = OrganizationsFunctions.getOrganizationalUnitChildAccounts(GetOrganizationalUnitChildAccountsArgs.builder()
     *             .parentId(org.applyValue(getOrganizationResult -> getOrganizationResult.roots()[0].id()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getOrganizationalUnitChildAccounts.
     * @return A collection of values returned by getOrganizationalUnitChildAccounts.
     */
    public suspend
    fun getOrganizationalUnitChildAccounts(argument: GetOrganizationalUnitChildAccountsPlainArgs):
        GetOrganizationalUnitChildAccountsResult =
        getOrganizationalUnitChildAccountsResultToKotlin(getOrganizationalUnitChildAccountsPlain(argument.toJava()).await())

    /**
     * @see [getOrganizationalUnitChildAccounts].
     * @param parentId The parent ID of the accounts.
     * @return A collection of values returned by getOrganizationalUnitChildAccounts.
     */
    public suspend fun getOrganizationalUnitChildAccounts(parentId: String):
        GetOrganizationalUnitChildAccountsResult {
        val argument = GetOrganizationalUnitChildAccountsPlainArgs(
            parentId = parentId,
        )
        return getOrganizationalUnitChildAccountsResultToKotlin(getOrganizationalUnitChildAccountsPlain(argument.toJava()).await())
    }

    /**
     * @see [getOrganizationalUnitChildAccounts].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;organizations&#46;kotlin&#46;inputs&#46;GetOrganizationalUnitChildAccountsPlainArgs].
     * @return A collection of values returned by getOrganizationalUnitChildAccounts.
     */
    public suspend
    fun getOrganizationalUnitChildAccounts(argument: suspend GetOrganizationalUnitChildAccountsPlainArgsBuilder.() -> Unit):
        GetOrganizationalUnitChildAccountsResult {
        val builder = GetOrganizationalUnitChildAccountsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrganizationalUnitChildAccountsResultToKotlin(getOrganizationalUnitChildAccountsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get all direct child accounts under a parent organizational unit. This provides all children.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.organizations.OrganizationsFunctions;
     * import com.pulumi.aws.organizations.inputs.GetOrganizationalUnitDescendantAccountsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var org = OrganizationsFunctions.getOrganization();
     *         final var accounts = OrganizationsFunctions.getOrganizationalUnitDescendantAccounts(GetOrganizationalUnitDescendantAccountsArgs.builder()
     *             .parentId(org.applyValue(getOrganizationResult -> getOrganizationResult.roots()[0].id()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getOrganizationalUnitDescendantAccounts.
     * @return A collection of values returned by getOrganizationalUnitDescendantAccounts.
     */
    public suspend
    fun getOrganizationalUnitDescendantAccounts(argument: GetOrganizationalUnitDescendantAccountsPlainArgs):
        GetOrganizationalUnitDescendantAccountsResult =
        getOrganizationalUnitDescendantAccountsResultToKotlin(getOrganizationalUnitDescendantAccountsPlain(argument.toJava()).await())

    /**
     * @see [getOrganizationalUnitDescendantAccounts].
     * @param parentId The parent ID of the accounts.
     * @return A collection of values returned by getOrganizationalUnitDescendantAccounts.
     */
    public suspend fun getOrganizationalUnitDescendantAccounts(parentId: String):
        GetOrganizationalUnitDescendantAccountsResult {
        val argument = GetOrganizationalUnitDescendantAccountsPlainArgs(
            parentId = parentId,
        )
        return getOrganizationalUnitDescendantAccountsResultToKotlin(getOrganizationalUnitDescendantAccountsPlain(argument.toJava()).await())
    }

    /**
     * @see [getOrganizationalUnitDescendantAccounts].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;organizations&#46;kotlin&#46;inputs&#46;GetOrganizationalUnitDescendantAccountsPlainArgs].
     * @return A collection of values returned by getOrganizationalUnitDescendantAccounts.
     */
    public suspend
    fun getOrganizationalUnitDescendantAccounts(argument: suspend GetOrganizationalUnitDescendantAccountsPlainArgsBuilder.() -> Unit):
        GetOrganizationalUnitDescendantAccountsResult {
        val builder = GetOrganizationalUnitDescendantAccountsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrganizationalUnitDescendantAccountsResultToKotlin(getOrganizationalUnitDescendantAccountsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get all direct child organizational units under a parent organizational unit. This only provides immediate children, not all children.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.organizations.OrganizationsFunctions;
     * import com.pulumi.aws.organizations.inputs.GetOrganizationalUnitsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var org = OrganizationsFunctions.getOrganization();
     *         final var ou = OrganizationsFunctions.getOrganizationalUnits(GetOrganizationalUnitsArgs.builder()
     *             .parentId(org.applyValue(getOrganizationResult -> getOrganizationResult.roots()[0].id()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getOrganizationalUnits.
     * @return A collection of values returned by getOrganizationalUnits.
     */
    public suspend fun getOrganizationalUnits(argument: GetOrganizationalUnitsPlainArgs):
        GetOrganizationalUnitsResult =
        getOrganizationalUnitsResultToKotlin(getOrganizationalUnitsPlain(argument.toJava()).await())

    /**
     * @see [getOrganizationalUnits].
     * @param parentId Parent ID of the organizational unit.
     * @return A collection of values returned by getOrganizationalUnits.
     */
    public suspend fun getOrganizationalUnits(parentId: String): GetOrganizationalUnitsResult {
        val argument = GetOrganizationalUnitsPlainArgs(
            parentId = parentId,
        )
        return getOrganizationalUnitsResultToKotlin(getOrganizationalUnitsPlain(argument.toJava()).await())
    }

    /**
     * @see [getOrganizationalUnits].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;organizations&#46;kotlin&#46;inputs&#46;GetOrganizationalUnitsPlainArgs].
     * @return A collection of values returned by getOrganizationalUnits.
     */
    public suspend
    fun getOrganizationalUnits(argument: suspend GetOrganizationalUnitsPlainArgsBuilder.() -> Unit):
        GetOrganizationalUnitsResult {
        val builder = GetOrganizationalUnitsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrganizationalUnitsResultToKotlin(getOrganizationalUnitsPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS Organizations Policies.
     * {{% examples %}}
     * ## Example Usage
     * {{% /examples %}}
     * @param argument A collection of arguments for invoking getPolicies.
     * @return A collection of values returned by getPolicies.
     */
    public suspend fun getPolicies(argument: GetPoliciesPlainArgs): GetPoliciesResult =
        getPoliciesResultToKotlin(getPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getPolicies].
     * @param filter The type of policies to be returned in the response. Valid values are `SERVICE_CONTROL_POLICY | TAG_POLICY | BACKUP_POLICY | AISERVICES_OPT_OUT_POLICY`
     * @return A collection of values returned by getPolicies.
     */
    public suspend fun getPolicies(filter: String): GetPoliciesResult {
        val argument = GetPoliciesPlainArgs(
            filter = filter,
        )
        return getPoliciesResultToKotlin(getPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;organizations&#46;kotlin&#46;inputs&#46;GetPoliciesPlainArgs].
     * @return A collection of values returned by getPolicies.
     */
    public suspend fun getPolicies(argument: suspend GetPoliciesPlainArgsBuilder.() -> Unit):
        GetPoliciesResult {
        val builder = GetPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPoliciesResultToKotlin(getPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS Organizations Policies For Target.
     * {{% examples %}}
     * ## Example Usage
     * {{% /examples %}}
     * @param argument A collection of arguments for invoking getPoliciesForTarget.
     * @return A collection of values returned by getPoliciesForTarget.
     */
    public suspend fun getPoliciesForTarget(argument: GetPoliciesForTargetPlainArgs):
        GetPoliciesForTargetResult =
        getPoliciesForTargetResultToKotlin(getPoliciesForTargetPlain(argument.toJava()).await())

    /**
     * @see [getPoliciesForTarget].
     * @param filter Must supply one of the 4 different policy filters for a target (SERVICE_CONTROL_POLICY | TAG_POLICY | BACKUP_POLICY | AISERVICES_OPT_OUT_POLICY)
     * @param targetId The root (string that begins with "r-" followed by 4-32 lowercase letters or digits), account (12 digit string), or Organizational Unit (string starting with "ou-" followed by 4-32 lowercase letters or digits. This string is followed by a second "-" dash and from 8-32 additional lowercase letters or digits.)
     * @return A collection of values returned by getPoliciesForTarget.
     */
    public suspend fun getPoliciesForTarget(filter: String, targetId: String):
        GetPoliciesForTargetResult {
        val argument = GetPoliciesForTargetPlainArgs(
            filter = filter,
            targetId = targetId,
        )
        return getPoliciesForTargetResultToKotlin(getPoliciesForTargetPlain(argument.toJava()).await())
    }

    /**
     * @see [getPoliciesForTarget].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;organizations&#46;kotlin&#46;inputs&#46;GetPoliciesForTargetPlainArgs].
     * @return A collection of values returned by getPoliciesForTarget.
     */
    public suspend
    fun getPoliciesForTarget(argument: suspend GetPoliciesForTargetPlainArgsBuilder.() -> Unit):
        GetPoliciesForTargetResult {
        val builder = GetPoliciesForTargetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPoliciesForTargetResultToKotlin(getPoliciesForTargetPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS Organizations Policy.
     * {{% examples %}}
     * ## Example Usage
     * {{% /examples %}}
     * @param argument A collection of arguments for invoking getPolicy.
     * @return A collection of values returned by getPolicy.
     */
    public suspend fun getPolicy(argument: GetPolicyPlainArgs): GetPolicyResult =
        getPolicyResultToKotlin(getPolicyPlain(argument.toJava()).await())

    /**
     * @see [getPolicy].
     * @param policyId The unique identifier (ID) of the policy that you want more details on. Policy id starts with a "p-" followed by 8-28 lowercase or uppercase letters, digits, and underscores.
     * @return A collection of values returned by getPolicy.
     */
    public suspend fun getPolicy(policyId: String): GetPolicyResult {
        val argument = GetPolicyPlainArgs(
            policyId = policyId,
        )
        return getPolicyResultToKotlin(getPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;organizations&#46;kotlin&#46;inputs&#46;GetPolicyPlainArgs].
     * @return A collection of values returned by getPolicy.
     */
    public suspend fun getPolicy(argument: suspend GetPolicyPlainArgsBuilder.() -> Unit):
        GetPolicyResult {
        val builder = GetPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyResultToKotlin(getPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get tags attached to the specified AWS Organizations resource.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.organizations.OrganizationsFunctions;
     * import com.pulumi.aws.organizations.inputs.GetResourceTagsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var account = OrganizationsFunctions.getResourceTags(GetResourceTagsArgs.builder()
     *             .resourceId("123456123846")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getResourceTags.
     * @return A collection of values returned by getResourceTags.
     */
    public suspend fun getResourceTags(argument: GetResourceTagsPlainArgs): GetResourceTagsResult =
        getResourceTagsResultToKotlin(getResourceTagsPlain(argument.toJava()).await())

    /**
     * @see [getResourceTags].
     * @param resourceId ID of the resource with the tags to list. See details below.
     * @param tags Map of key=value pairs for each tag set on the resource.
     * @return A collection of values returned by getResourceTags.
     */
    public suspend fun getResourceTags(resourceId: String, tags: Map<String, String>? = null):
        GetResourceTagsResult {
        val argument = GetResourceTagsPlainArgs(
            resourceId = resourceId,
            tags = tags,
        )
        return getResourceTagsResultToKotlin(getResourceTagsPlain(argument.toJava()).await())
    }

    /**
     * @see [getResourceTags].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;organizations&#46;kotlin&#46;inputs&#46;GetResourceTagsPlainArgs].
     * @return A collection of values returned by getResourceTags.
     */
    public suspend fun getResourceTags(argument: suspend GetResourceTagsPlainArgsBuilder.() -> Unit):
        GetResourceTagsResult {
        val builder = GetResourceTagsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceTagsResultToKotlin(getResourceTagsPlain(builtArgument.toJava()).await())
    }
}
