@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin

import com.pulumi.aws.organizations.PolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an [AWS Organizations policy](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.organizations.Policy;
 * import com.pulumi.aws.organizations.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var examplePolicy = new Policy("examplePolicy", PolicyArgs.builder()
 *             .content(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_organizations_policy` using the policy ID. For example:
 * ```sh
 *  $ pulumi import aws:organizations/policy:Policy example p-12345678
 * ```
 * @property content The policy content to add to the new policy. For example, if you create a [service control policy (SCP)](https://docs&#46;aws&#46;amazon&#46;com/organizations/latest/userguide/orgs_manage_policies_scp&#46;html), this string must be JSON text that specifies the permissions that admins in attached accounts can delegate to their users, groups, and roles&#46; For more information about the SCP syntax, see the [Service Control Policy Syntax documentation](https://docs&#46;aws&#46;amazon&#46;com/organizations/latest/userguide/orgs_reference_scp-syntax&#46;html) and for more information on the Tag Policy syntax, see the [Tag Policy Syntax documentation](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_example-tag-policies.html).
 * @property description A description to assign to the policy.
 * @property name The friendly name to assign to the policy.
 * @property skipDestroy If set to `true`, destroy will **not** delete the policy and instead just remove the resource from state. This can be useful in situations where the policies (and the associated attachment) must be preserved to meet the AWS minimum requirement of 1 attached policy.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The type of policy to create. Valid values are `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `SERVICE_CONTROL_POLICY` (SCP), and `TAG_POLICY`. Defaults to `SERVICE_CONTROL_POLICY`.
 */
public data class PolicyArgs(
    public val content: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val skipDestroy: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.organizations.PolicyArgs> {
    override fun toJava(): com.pulumi.aws.organizations.PolicyArgs =
        com.pulumi.aws.organizations.PolicyArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var skipDestroy: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The policy content to add to the new policy. For example, if you create a [service control policy (SCP)](https://docs&#46;aws&#46;amazon&#46;com/organizations/latest/userguide/orgs_manage_policies_scp&#46;html), this string must be JSON text that specifies the permissions that admins in attached accounts can delegate to their users, groups, and roles&#46; For more information about the SCP syntax, see the [Service Control Policy Syntax documentation](https://docs&#46;aws&#46;amazon&#46;com/organizations/latest/userguide/orgs_reference_scp-syntax&#46;html) and for more information on the Tag Policy syntax, see the [Tag Policy Syntax documentation](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_example-tag-policies.html).
     */
    @JvmName("ycxprpsoxsrvwntn")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value A description to assign to the policy.
     */
    @JvmName("euydngqaraualfrf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The friendly name to assign to the policy.
     */
    @JvmName("gexehvdernujpdry")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value If set to `true`, destroy will **not** delete the policy and instead just remove the resource from state. This can be useful in situations where the policies (and the associated attachment) must be preserved to meet the AWS minimum requirement of 1 attached policy.
     */
    @JvmName("hkxsfsyjvhklmact")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ceapwcwnphqqlcvj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of policy to create. Valid values are `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `SERVICE_CONTROL_POLICY` (SCP), and `TAG_POLICY`. Defaults to `SERVICE_CONTROL_POLICY`.
     */
    @JvmName("bjdcfpbeyqwwrbac")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The policy content to add to the new policy. For example, if you create a [service control policy (SCP)](https://docs&#46;aws&#46;amazon&#46;com/organizations/latest/userguide/orgs_manage_policies_scp&#46;html), this string must be JSON text that specifies the permissions that admins in attached accounts can delegate to their users, groups, and roles&#46; For more information about the SCP syntax, see the [Service Control Policy Syntax documentation](https://docs&#46;aws&#46;amazon&#46;com/organizations/latest/userguide/orgs_reference_scp-syntax&#46;html) and for more information on the Tag Policy syntax, see the [Tag Policy Syntax documentation](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_example-tag-policies.html).
     */
    @JvmName("rkhicyiioevyeofq")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value A description to assign to the policy.
     */
    @JvmName("byyrleqewniuprjs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The friendly name to assign to the policy.
     */
    @JvmName("gbsdrkbfdeckchfe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value If set to `true`, destroy will **not** delete the policy and instead just remove the resource from state. This can be useful in situations where the policies (and the associated attachment) must be preserved to meet the AWS minimum requirement of 1 attached policy.
     */
    @JvmName("fdryxgkfwrrawacm")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yimmwwdwmxjwjixm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wkddtnlnrknttnhk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of policy to create. Valid values are `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `SERVICE_CONTROL_POLICY` (SCP), and `TAG_POLICY`. Defaults to `SERVICE_CONTROL_POLICY`.
     */
    @JvmName("awbgrbenpxobilbh")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        content = content,
        description = description,
        name = name,
        skipDestroy = skipDestroy,
        tags = tags,
        type = type,
    )
}
