@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin

import com.pulumi.aws.organizations.PolicyAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to attach an AWS Organizations policy to an organization account, root, or unit.
 * ## Example Usage
 * ### Organization Account
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.PolicyAttachment;
 * import com.pulumi.aws.organizations.PolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new PolicyAttachment("account", PolicyAttachmentArgs.builder()
 *             .policyId(aws_organizations_policy.example().id())
 *             .targetId("123456789012")
 *             .build());
 *     }
 * }
 * ```
 * ### Organization Root
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.PolicyAttachment;
 * import com.pulumi.aws.organizations.PolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var root = new PolicyAttachment("root", PolicyAttachmentArgs.builder()
 *             .policyId(aws_organizations_policy.example().id())
 *             .targetId(aws_organizations_organization.example().roots()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ### Organization Unit
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.PolicyAttachment;
 * import com.pulumi.aws.organizations.PolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var unit = new PolicyAttachment("unit", PolicyAttachmentArgs.builder()
 *             .policyId(aws_organizations_policy.example().id())
 *             .targetId(aws_organizations_organizational_unit.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_organizations_policy_attachment` using the target ID and policy ID. For example:
 * With an account target:
 * ```sh
 *  $ pulumi import aws:organizations/policyAttachment:PolicyAttachment account 123456789012:p-12345678
 * ```
 * @property policyId The unique identifier (ID) of the policy that you want to attach to the target.
 * @property skipDestroy If set to `true`, destroy will **not** detach the policy and instead just remove the resource from state. This can be useful in situations where the attachment must be preserved to meet the AWS minimum requirement of 1 attached policy.
 * @property targetId The unique identifier (ID) of the root, organizational unit, or account number that you want to attach the policy to.
 */
public data class PolicyAttachmentArgs(
    public val policyId: Output<String>? = null,
    public val skipDestroy: Output<Boolean>? = null,
    public val targetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.organizations.PolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.organizations.PolicyAttachmentArgs =
        com.pulumi.aws.organizations.PolicyAttachmentArgs.builder()
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 }))
            .targetId(targetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyAttachmentArgs].
 */
@PulumiTagMarker
public class PolicyAttachmentArgsBuilder internal constructor() {
    private var policyId: Output<String>? = null

    private var skipDestroy: Output<Boolean>? = null

    private var targetId: Output<String>? = null

    /**
     * @param value The unique identifier (ID) of the policy that you want to attach to the target.
     */
    @JvmName("teyydvgnxqsfcusr")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value If set to `true`, destroy will **not** detach the policy and instead just remove the resource from state. This can be useful in situations where the attachment must be preserved to meet the AWS minimum requirement of 1 attached policy.
     */
    @JvmName("wxtlpmvrgvcjaiaj")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value The unique identifier (ID) of the root, organizational unit, or account number that you want to attach the policy to.
     */
    @JvmName("ybnsgxihosddvxsy")
    public suspend fun targetId(`value`: Output<String>) {
        this.targetId = value
    }

    /**
     * @param value The unique identifier (ID) of the policy that you want to attach to the target.
     */
    @JvmName("vqcnsyodiqvyeikg")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value If set to `true`, destroy will **not** detach the policy and instead just remove the resource from state. This can be useful in situations where the attachment must be preserved to meet the AWS minimum requirement of 1 attached policy.
     */
    @JvmName("ufnjqbwxkkdysmav")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    /**
     * @param value The unique identifier (ID) of the root, organizational unit, or account number that you want to attach the policy to.
     */
    @JvmName("jvcxdtbjpuirybyj")
    public suspend fun targetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetId = mapped
    }

    internal fun build(): PolicyAttachmentArgs = PolicyAttachmentArgs(
        policyId = policyId,
        skipDestroy = skipDestroy,
        targetId = targetId,
    )
}
