@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.inputs

import com.pulumi.aws.organizations.inputs.GetOrganizationalUnitChildAccountsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOrganizationalUnitChildAccounts.
 * @property parentId The parent ID of the accounts.
 */
public data class GetOrganizationalUnitChildAccountsPlainArgs(
    public val parentId: String,
) :
    ConvertibleToJava<com.pulumi.aws.organizations.inputs.GetOrganizationalUnitChildAccountsPlainArgs> {
    override fun toJava():
        com.pulumi.aws.organizations.inputs.GetOrganizationalUnitChildAccountsPlainArgs =
        com.pulumi.aws.organizations.inputs.GetOrganizationalUnitChildAccountsPlainArgs.builder()
            .parentId(parentId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOrganizationalUnitChildAccountsPlainArgs].
 */
@PulumiTagMarker
public class GetOrganizationalUnitChildAccountsPlainArgsBuilder internal constructor() {
    private var parentId: String? = null

    /**
     * @param value The parent ID of the accounts.
     */
    @JvmName("grsqsqeypjmpgkat")
    public suspend fun parentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parentId = mapped
    }

    internal fun build(): GetOrganizationalUnitChildAccountsPlainArgs =
        GetOrganizationalUnitChildAccountsPlainArgs(
            parentId = parentId ?: throw PulumiNullFieldException("parentId"),
        )
}
