@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.inputs

import com.pulumi.aws.organizations.inputs.GetOrganizationalUnitsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOrganizationalUnits.
 * @property parentId Parent ID of the organizational unit.
 */
public data class GetOrganizationalUnitsPlainArgs(
    public val parentId: String,
) : ConvertibleToJava<com.pulumi.aws.organizations.inputs.GetOrganizationalUnitsPlainArgs> {
    override fun toJava(): com.pulumi.aws.organizations.inputs.GetOrganizationalUnitsPlainArgs =
        com.pulumi.aws.organizations.inputs.GetOrganizationalUnitsPlainArgs.builder()
            .parentId(parentId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOrganizationalUnitsPlainArgs].
 */
@PulumiTagMarker
public class GetOrganizationalUnitsPlainArgsBuilder internal constructor() {
    private var parentId: String? = null

    /**
     * @param value Parent ID of the organizational unit.
     */
    @JvmName("ckmrameaonpgjhnu")
    public suspend fun parentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parentId = mapped
    }

    internal fun build(): GetOrganizationalUnitsPlainArgs = GetOrganizationalUnitsPlainArgs(
        parentId = parentId ?: throw PulumiNullFieldException("parentId"),
    )
}
