@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.inputs

import com.pulumi.aws.organizations.inputs.GetPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPolicies.
 * @property filter The type of policies to be returned in the response. Valid values are `SERVICE_CONTROL_POLICY | TAG_POLICY | BACKUP_POLICY | AISERVICES_OPT_OUT_POLICY`
 */
public data class GetPoliciesPlainArgs(
    public val filter: String,
) : ConvertibleToJava<com.pulumi.aws.organizations.inputs.GetPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.aws.organizations.inputs.GetPoliciesPlainArgs =
        com.pulumi.aws.organizations.inputs.GetPoliciesPlainArgs.builder()
            .filter(filter.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetPoliciesPlainArgsBuilder internal constructor() {
    private var filter: String? = null

    /**
     * @param value The type of policies to be returned in the response. Valid values are `SERVICE_CONTROL_POLICY | TAG_POLICY | BACKUP_POLICY | AISERVICES_OPT_OUT_POLICY`
     */
    @JvmName("doupnkcogjryflrg")
    public suspend fun filter(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filter = mapped
    }

    internal fun build(): GetPoliciesPlainArgs = GetPoliciesPlainArgs(
        filter = filter ?: throw PulumiNullFieldException("filter"),
    )
}
