@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.inputs

import com.pulumi.aws.organizations.inputs.GetResourceTagsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResourceTags.
 * @property resourceId ID of the resource with the tags to list. See details below.
 * @property tags Map of key=value pairs for each tag set on the resource.
 */
public data class GetResourceTagsPlainArgs(
    public val resourceId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.organizations.inputs.GetResourceTagsPlainArgs> {
    override fun toJava(): com.pulumi.aws.organizations.inputs.GetResourceTagsPlainArgs =
        com.pulumi.aws.organizations.inputs.GetResourceTagsPlainArgs.builder()
            .resourceId(resourceId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetResourceTagsPlainArgs].
 */
@PulumiTagMarker
public class GetResourceTagsPlainArgsBuilder internal constructor() {
    private var resourceId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID of the resource with the tags to list. See details below.
     */
    @JvmName("jrrktmltbvupufcc")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceId = mapped
    }

    /**
     * @param value Map of key=value pairs for each tag set on the resource.
     */
    @JvmName("ndavfqmtncyrjbjo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of key=value pairs for each tag set on the resource.
     */
    @JvmName("ehcndfipsbcosghy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetResourceTagsPlainArgs = GetResourceTagsPlainArgs(
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
        tags = tags,
    )
}
