@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property delegationEnabledDate The date that the account became a delegated administrator for this service.
 * @property servicePrincipal The name of an AWS service that can request an operation for the specified service.
 */
public data class GetDelegatedServicesDelegatedService(
    public val delegationEnabledDate: String,
    public val servicePrincipal: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.GetDelegatedServicesDelegatedService):
            GetDelegatedServicesDelegatedService = GetDelegatedServicesDelegatedService(
            delegationEnabledDate = javaType.delegationEnabledDate(),
            servicePrincipal = javaType.servicePrincipal(),
        )
    }
}
