@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDelegatedServices.
 * @property accountId
 * @property delegatedServices Services for which the account is a delegated administrator, which have the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetDelegatedServicesResult(
    public val accountId: String,
    public val delegatedServices: List<GetDelegatedServicesDelegatedService>,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.GetDelegatedServicesResult):
            GetDelegatedServicesResult = GetDelegatedServicesResult(
            accountId = javaType.accountId(),
            delegatedServices = javaType.delegatedServices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.organizations.kotlin.outputs.GetDelegatedServicesDelegatedService.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
        )
    }
}
