@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn ARN of the root
 * @property email Email of the account
 * @property id Identifier of the root
 * @property name The name of the policy type
 * @property status The status of the policy type as it relates to the associated root
 */
public data class GetOrganizationNonMasterAccount(
    public val arn: String,
    public val email: String,
    public val id: String,
    public val name: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.GetOrganizationNonMasterAccount):
            GetOrganizationNonMasterAccount = GetOrganizationNonMasterAccount(
            arn = javaType.arn(),
            email = javaType.email(),
            id = javaType.id(),
            name = javaType.name(),
            status = javaType.status(),
        )
    }
}
