@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOrganization.
 * @property accounts List of organization accounts including the master account. For a list excluding the master account, see the `non_master_accounts` attribute. All elements have these attributes:
 * @property arn ARN of the root
 * @property awsServiceAccessPrincipals A list of AWS service principal names that have integration enabled with your organization. Organization must have `feature_set` set to `ALL`. For additional information, see the [AWS Organizations User Guide](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html).
 * @property enabledPolicyTypes A list of Organizations policy types that are enabled in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `SERVICE_CONTROL_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
 * @property featureSet FeatureSet of the organization.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property masterAccountArn ARN of the account that is designated as the master account for the organization.
 * @property masterAccountEmail The email address that is associated with the AWS account that is designated as the master account for the organization.
 * @property masterAccountId Unique identifier (ID) of the master account of an organization.
 * @property nonMasterAccounts List of organization accounts excluding the master account. For a list including the master account, see the `accounts` attribute. All elements have these attributes:
 * @property roots List of organization roots. All elements have these attributes:
 */
public data class GetOrganizationResult(
    public val accounts: List<GetOrganizationAccount>,
    public val arn: String,
    public val awsServiceAccessPrincipals: List<String>,
    public val enabledPolicyTypes: List<String>,
    public val featureSet: String,
    public val id: String,
    public val masterAccountArn: String,
    public val masterAccountEmail: String,
    public val masterAccountId: String,
    public val nonMasterAccounts: List<GetOrganizationNonMasterAccount>,
    public val roots: List<GetOrganizationRoot>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.GetOrganizationResult):
            GetOrganizationResult = GetOrganizationResult(
            accounts = javaType.accounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.organizations.kotlin.outputs.GetOrganizationAccount.Companion.toKotlin(args0)
                })
            }),
            arn = javaType.arn(),
            awsServiceAccessPrincipals = javaType.awsServiceAccessPrincipals().map({ args0 -> args0 }),
            enabledPolicyTypes = javaType.enabledPolicyTypes().map({ args0 -> args0 }),
            featureSet = javaType.featureSet(),
            id = javaType.id(),
            masterAccountArn = javaType.masterAccountArn(),
            masterAccountEmail = javaType.masterAccountEmail(),
            masterAccountId = javaType.masterAccountId(),
            nonMasterAccounts = javaType.nonMasterAccounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.organizations.kotlin.outputs.GetOrganizationNonMasterAccount.Companion.toKotlin(args0)
                })
            }),
            roots = javaType.roots().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.organizations.kotlin.outputs.GetOrganizationRoot.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
