@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property arn ARN of the root
 * @property id Identifier of the root
 * @property name The name of the policy type
 * @property policyTypes List of policy types enabled for this root. All elements have these attributes:
 */
public data class GetOrganizationRoot(
    public val arn: String,
    public val id: String,
    public val name: String,
    public val policyTypes: List<GetOrganizationRootPolicyType>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.GetOrganizationRoot):
            GetOrganizationRoot = GetOrganizationRoot(
            arn = javaType.arn(),
            id = javaType.id(),
            name = javaType.name(),
            policyTypes = javaType.policyTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.organizations.kotlin.outputs.GetOrganizationRootPolicyType.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
