@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getOrganizationalUnit.
 * @property arn ARN of the organizational unit
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property parentId
 */
public data class GetOrganizationalUnitResult(
    public val arn: String,
    public val id: String,
    public val name: String,
    public val parentId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.GetOrganizationalUnitResult):
            GetOrganizationalUnitResult = GetOrganizationalUnitResult(
            arn = javaType.arn(),
            id = javaType.id(),
            name = javaType.name(),
            parentId = javaType.parentId(),
        )
    }
}
