@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getPolicy.
 * @property arn The Amazon Resource Name of the policy.
 * @property awsManaged Indicates if a policy is an AWS managed policy.
 * @property content The text content of the policy.
 * @property description The description of the policy.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name The friendly name of the policy.
 * @property policyId
 * @property type The type of policy values can be `SERVICE_CONTROL_POLICY | TAG_POLICY | BACKUP_POLICY | AISERVICES_OPT_OUT_POLICY`
 */
public data class GetPolicyResult(
    public val arn: String,
    public val awsManaged: Boolean,
    public val content: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val policyId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.GetPolicyResult):
            GetPolicyResult = GetPolicyResult(
            arn = javaType.arn(),
            awsManaged = javaType.awsManaged(),
            content = javaType.content(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            policyId = javaType.policyId(),
            type = javaType.type(),
        )
    }
}
