@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property arn ARN of the root
 * @property id Identifier of the root
 * @property name The name of the policy type
 * @property policyTypes List of policy types enabled for this root. All elements have these attributes:
 */
public data class OrganizationRoot(
    public val arn: String? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val policyTypes: List<OrganizationRootPolicyType>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.OrganizationRoot):
            OrganizationRoot = OrganizationRoot(
            arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            policyTypes = javaType.policyTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.organizations.kotlin.outputs.OrganizationRootPolicyType.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
