@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn ARN of the organizational unit
 * @property email Email of the account
 * @property id Identifier of the organization unit
 * @property name The name for the organizational unit
 */
public data class OrganizationalUnitAccount(
    public val arn: String? = null,
    public val email: String? = null,
    public val id: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.OrganizationalUnitAccount):
            OrganizationalUnitAccount = OrganizationalUnitAccount(
            arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
