@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin.inputs

import com.pulumi.aws.outposts.inputs.GetAssetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAsset.
 * @property arn Outpost ARN.
 * @property assetId ID of the asset.
 */
public data class GetAssetPlainArgs(
    public val arn: String,
    public val assetId: String,
) : ConvertibleToJava<com.pulumi.aws.outposts.inputs.GetAssetPlainArgs> {
    override fun toJava(): com.pulumi.aws.outposts.inputs.GetAssetPlainArgs =
        com.pulumi.aws.outposts.inputs.GetAssetPlainArgs.builder()
            .arn(arn.let({ args0 -> args0 }))
            .assetId(assetId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAssetPlainArgs].
 */
@PulumiTagMarker
public class GetAssetPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var assetId: String? = null

    /**
     * @param value Outpost ARN.
     */
    @JvmName("ijcvemamhwnnceey")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value ID of the asset.
     */
    @JvmName("ofehyvepmqtcilvx")
    public suspend fun assetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assetId = mapped
    }

    internal fun build(): GetAssetPlainArgs = GetAssetPlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        assetId = assetId ?: throw PulumiNullFieldException("assetId"),
    )
}
