@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin.inputs

import com.pulumi.aws.outposts.inputs.GetAssetsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAssets.
 * @property arn Outpost ARN.
 * @property hostIdFilters Filters by list of Host IDs of a Dedicated Host.
 * @property statusIdFilters Filters by list of state status. Valid values: "ACTIVE", "RETIRING".
 */
public data class GetAssetsPlainArgs(
    public val arn: String,
    public val hostIdFilters: List<String>? = null,
    public val statusIdFilters: List<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.outposts.inputs.GetAssetsPlainArgs> {
    override fun toJava(): com.pulumi.aws.outposts.inputs.GetAssetsPlainArgs =
        com.pulumi.aws.outposts.inputs.GetAssetsPlainArgs.builder()
            .arn(arn.let({ args0 -> args0 }))
            .hostIdFilters(hostIdFilters?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .statusIdFilters(statusIdFilters?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetAssetsPlainArgs].
 */
@PulumiTagMarker
public class GetAssetsPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var hostIdFilters: List<String>? = null

    private var statusIdFilters: List<String>? = null

    /**
     * @param value Outpost ARN.
     */
    @JvmName("jiynfxmswvfykxqj")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Filters by list of Host IDs of a Dedicated Host.
     */
    @JvmName("gaggafhxmhdgdnks")
    public suspend fun hostIdFilters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hostIdFilters = mapped
    }

    /**
     * @param values Filters by list of Host IDs of a Dedicated Host.
     */
    @JvmName("hrdyuvihsmvqtpcx")
    public suspend fun hostIdFilters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hostIdFilters = mapped
    }

    /**
     * @param value Filters by list of state status. Valid values: "ACTIVE", "RETIRING".
     */
    @JvmName("wfkbfiiiexchkcuw")
    public suspend fun statusIdFilters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.statusIdFilters = mapped
    }

    /**
     * @param values Filters by list of state status. Valid values: "ACTIVE", "RETIRING".
     */
    @JvmName("kvgsfkrarpseqixk")
    public suspend fun statusIdFilters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.statusIdFilters = mapped
    }

    internal fun build(): GetAssetsPlainArgs = GetAssetsPlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        hostIdFilters = hostIdFilters,
        statusIdFilters = statusIdFilters,
    )
}
