@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin.inputs

import com.pulumi.aws.outposts.inputs.GetOutpostInstanceTypePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOutpostInstanceType.
 * @property arn Outpost ARN.
 * The following arguments are optional:
 * @property instanceType Desired instance type. Conflicts with `preferred_instance_types`.
 * @property preferredInstanceTypes Ordered list of preferred instance types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. Conflicts with `instance_type`.
 */
public data class GetOutpostInstanceTypePlainArgs(
    public val arn: String,
    public val instanceType: String? = null,
    public val preferredInstanceTypes: List<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.outposts.inputs.GetOutpostInstanceTypePlainArgs> {
    override fun toJava(): com.pulumi.aws.outposts.inputs.GetOutpostInstanceTypePlainArgs =
        com.pulumi.aws.outposts.inputs.GetOutpostInstanceTypePlainArgs.builder()
            .arn(arn.let({ args0 -> args0 }))
            .instanceType(instanceType?.let({ args0 -> args0 }))
            .preferredInstanceTypes(
                preferredInstanceTypes?.let({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [GetOutpostInstanceTypePlainArgs].
 */
@PulumiTagMarker
public class GetOutpostInstanceTypePlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var instanceType: String? = null

    private var preferredInstanceTypes: List<String>? = null

    /**
     * @param value Outpost ARN.
     * The following arguments are optional:
     */
    @JvmName("uvxfbwyjsftnjsgi")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Desired instance type. Conflicts with `preferred_instance_types`.
     */
    @JvmName("olmlwcsxxtdgqtxd")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceType = mapped
    }

    /**
     * @param value Ordered list of preferred instance types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. Conflicts with `instance_type`.
     */
    @JvmName("bksgtnlpukspbawp")
    public suspend fun preferredInstanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.preferredInstanceTypes = mapped
    }

    /**
     * @param values Ordered list of preferred instance types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. Conflicts with `instance_type`.
     */
    @JvmName("rxgkuoutaohsajbr")
    public suspend fun preferredInstanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.preferredInstanceTypes = mapped
    }

    internal fun build(): GetOutpostInstanceTypePlainArgs = GetOutpostInstanceTypePlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        instanceType = instanceType,
        preferredInstanceTypes = preferredInstanceTypes,
    )
}
