@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin.inputs

import com.pulumi.aws.outposts.inputs.GetOutpostPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOutpost.
 * @property arn ARN.
 * @property id Identifier of the Outpost.
 * @property name Name of the Outpost.
 * @property ownerId AWS Account identifier of the Outpost owner.
 * @property tags The Outpost tags.
 */
public data class GetOutpostPlainArgs(
    public val arn: String? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val ownerId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.outposts.inputs.GetOutpostPlainArgs> {
    override fun toJava(): com.pulumi.aws.outposts.inputs.GetOutpostPlainArgs =
        com.pulumi.aws.outposts.inputs.GetOutpostPlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .id(id?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .ownerId(ownerId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetOutpostPlainArgs].
 */
@PulumiTagMarker
public class GetOutpostPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var id: String? = null

    private var name: String? = null

    private var ownerId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN.
     */
    @JvmName("vkqfmayucppqcadb")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Identifier of the Outpost.
     */
    @JvmName("rbsmbrcipxpekbhm")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Name of the Outpost.
     */
    @JvmName("cwddixvoigojxmka")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value AWS Account identifier of the Outpost owner.
     */
    @JvmName("hapqwgtfswdqkfen")
    public suspend fun ownerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ownerId = mapped
    }

    /**
     * @param value The Outpost tags.
     */
    @JvmName("uqrvmksiyfvoaqsq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values The Outpost tags.
     */
    @JvmName("wofeqcyxmngqborn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetOutpostPlainArgs = GetOutpostPlainArgs(
        arn = arn,
        id = id,
        name = name,
        ownerId = ownerId,
        tags = tags,
    )
}
