@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin.inputs

import com.pulumi.aws.outposts.inputs.GetSitePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSite.
 * @property id Identifier of the Site.
 * @property name Name of the Site.
 */
public data class GetSitePlainArgs(
    public val id: String? = null,
    public val name: String? = null,
) : ConvertibleToJava<com.pulumi.aws.outposts.inputs.GetSitePlainArgs> {
    override fun toJava(): com.pulumi.aws.outposts.inputs.GetSitePlainArgs =
        com.pulumi.aws.outposts.inputs.GetSitePlainArgs.builder()
            .id(id?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSitePlainArgs].
 */
@PulumiTagMarker
public class GetSitePlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var name: String? = null

    /**
     * @param value Identifier of the Site.
     */
    @JvmName("mnwlaxbrmfkpukvh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Name of the Site.
     */
    @JvmName("afnvychxfeyuaufj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetSitePlainArgs = GetSitePlainArgs(
        id = id,
        name = name,
    )
}
