@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getOutpost.
 * @property arn
 * @property availabilityZone Availability Zone name.
 * @property availabilityZoneId Availability Zone identifier.
 * @property description The description of the Outpost.
 * @property id
 * @property lifecycleStatus The life cycle status.
 * @property name
 * @property ownerId
 * @property siteArn The Amazon Resource Name (ARN) of the site.
 * @property siteId The ID of the site.
 * @property supportedHardwareType The hardware type.
 * @property tags The Outpost tags.
 */
public data class GetOutpostResult(
    public val arn: String,
    public val availabilityZone: String,
    public val availabilityZoneId: String,
    public val description: String,
    public val id: String,
    public val lifecycleStatus: String,
    public val name: String,
    public val ownerId: String? = null,
    public val siteArn: String,
    public val siteId: String,
    public val supportedHardwareType: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outposts.outputs.GetOutpostResult):
            GetOutpostResult = GetOutpostResult(
            arn = javaType.arn(),
            availabilityZone = javaType.availabilityZone(),
            availabilityZoneId = javaType.availabilityZoneId(),
            description = javaType.description(),
            id = javaType.id(),
            lifecycleStatus = javaType.lifecycleStatus(),
            name = javaType.name(),
            ownerId = javaType.ownerId().map({ args0 -> args0 }).orElse(null),
            siteArn = javaType.siteArn(),
            siteId = javaType.siteId(),
            supportedHardwareType = javaType.supportedHardwareType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
