@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSites.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids Set of Outposts Site identifiers.
 */
public data class GetSitesResult(
    public val id: String,
    public val ids: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outposts.outputs.GetSitesResult): GetSitesResult =
            GetSitesResult(
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
            )
    }
}
