@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AdmChannel].
 */
@PulumiTagMarker
public class AdmChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AdmChannelArgs = AdmChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AdmChannelArgsBuilder.() -> Unit) {
        val builder = AdmChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AdmChannel {
        val builtJavaResource = com.pulumi.aws.pinpoint.AdmChannel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AdmChannel(builtJavaResource)
    }
}

/**
 * Provides a Pinpoint ADM (Amazon Device Messaging) Channel resource.
 * > **Note:** All arguments including the Client ID and Client Secret will be stored in the raw state as plain-text.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.AdmChannel;
 * import com.pulumi.aws.pinpoint.AdmChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         var channel = new AdmChannel("channel", AdmChannelArgs.builder()
 *             .applicationId(app.applicationId())
 *             .clientId("")
 *             .clientSecret("")
 *             .enabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Pinpoint ADM Channel using the `application-id`. For example:
 * ```sh
 *  $ pulumi import aws:pinpoint/admChannel:AdmChannel channel application-id
 * ```
 *
 */
public class AdmChannel internal constructor(
    override val javaResource: com.pulumi.aws.pinpoint.AdmChannel,
) : KotlinCustomResource(javaResource, AdmChannelMapper) {
    /**
     * The application ID.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * Client ID (part of OAuth Credentials) obtained via Amazon Developer Account.
     */
    public val clientId: Output<String>
        get() = javaResource.clientId().applyValue({ args0 -> args0 })

    /**
     * Client Secret (part of OAuth Credentials) obtained via Amazon Developer Account.
     */
    public val clientSecret: Output<String>
        get() = javaResource.clientSecret().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable the channel. Defaults to `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AdmChannelMapper : ResourceMapper<AdmChannel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.pinpoint.AdmChannel::class == javaResource::class

    override fun map(javaResource: Resource): AdmChannel = AdmChannel(
        javaResource as
            com.pulumi.aws.pinpoint.AdmChannel,
    )
}

/**
 * @see [AdmChannel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AdmChannel].
 */
public suspend fun admChannel(name: String, block: suspend AdmChannelResourceBuilder.() -> Unit):
    AdmChannel {
    val builder = AdmChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AdmChannel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun admChannel(name: String): AdmChannel {
    val builder = AdmChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
