@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.aws.pinpoint.AdmChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Pinpoint ADM (Amazon Device Messaging) Channel resource.
 * > **Note:** All arguments including the Client ID and Client Secret will be stored in the raw state as plain-text.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.AdmChannel;
 * import com.pulumi.aws.pinpoint.AdmChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         var channel = new AdmChannel("channel", AdmChannelArgs.builder()
 *             .applicationId(app.applicationId())
 *             .clientId("")
 *             .clientSecret("")
 *             .enabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Pinpoint ADM Channel using the `application-id`. For example:
 * ```sh
 *  $ pulumi import aws:pinpoint/admChannel:AdmChannel channel application-id
 * ```
 * @property applicationId The application ID.
 * @property clientId Client ID (part of OAuth Credentials) obtained via Amazon Developer Account.
 * @property clientSecret Client Secret (part of OAuth Credentials) obtained via Amazon Developer Account.
 * @property enabled Specifies whether to enable the channel. Defaults to `true`.
 */
public data class AdmChannelArgs(
    public val applicationId: Output<String>? = null,
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.pinpoint.AdmChannelArgs> {
    override fun toJava(): com.pulumi.aws.pinpoint.AdmChannelArgs =
        com.pulumi.aws.pinpoint.AdmChannelArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdmChannelArgs].
 */
@PulumiTagMarker
public class AdmChannelArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value The application ID.
     */
    @JvmName("nnjoetuduwtsgnnp")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Client ID (part of OAuth Credentials) obtained via Amazon Developer Account.
     */
    @JvmName("tmcgoayuhsfmugak")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Client Secret (part of OAuth Credentials) obtained via Amazon Developer Account.
     */
    @JvmName("tmggwxhlglcvhgue")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value Specifies whether to enable the channel. Defaults to `true`.
     */
    @JvmName("sumvsrgfhmwrxyiy")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The application ID.
     */
    @JvmName("noxjpgkqjqcxkphd")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Client ID (part of OAuth Credentials) obtained via Amazon Developer Account.
     */
    @JvmName("tyhbhuneuqvmelmh")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Client Secret (part of OAuth Credentials) obtained via Amazon Developer Account.
     */
    @JvmName("vqslntjbmpkyshdf")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value Specifies whether to enable the channel. Defaults to `true`.
     */
    @JvmName("plwnavqtpkydoplb")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): AdmChannelArgs = AdmChannelArgs(
        applicationId = applicationId,
        clientId = clientId,
        clientSecret = clientSecret,
        enabled = enabled,
    )
}
