@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.aws.pinpoint.ApnsVoipSandboxChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Pinpoint APNs VoIP Sandbox Channel resource.
 * > **Note:** All arguments, including certificates and tokens, will be stored in the raw state as plain-text.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.ApnsVoipSandboxChannel;
 * import com.pulumi.aws.pinpoint.ApnsVoipSandboxChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         var apnsVoipSandbox = new ApnsVoipSandboxChannel("apnsVoipSandbox", ApnsVoipSandboxChannelArgs.builder()
 *             .applicationId(app.applicationId())
 *             .certificate(Files.readString(Paths.get("./certificate.pem")))
 *             .privateKey(Files.readString(Paths.get("./private_key.key")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Pinpoint APNs VoIP Sandbox Channel using the `application-id`. For example:
 * ```sh
 *  $ pulumi import aws:pinpoint/apnsVoipSandboxChannel:ApnsVoipSandboxChannel apns_voip_sandbox application-id
 * ```
 * @property applicationId The application ID.
 * @property bundleId The ID assigned to your iOS app. To find this value, choose Certificates, IDs & Profiles, choose App IDs in the Identifiers section, and choose your app.
 * @property certificate The pem encoded TLS Certificate from Apple.
 * @property defaultAuthenticationMethod The default authentication method used for APNs.
 * __NOTE__: Amazon Pinpoint uses this default for every APNs push notification that you send using the console.
 * You can override the default when you send a message programmatically using the Amazon Pinpoint API, the AWS CLI, or an AWS SDK.
 * If your default authentication type fails, Amazon Pinpoint doesn't attempt to use the other authentication type.
 * One of the following sets of credentials is also required.
 * If you choose to use __Certificate credentials__ you will have to provide:
 * @property enabled Whether the channel is enabled or disabled. Defaults to `true`.
 * @property privateKey The Certificate Private Key file (ie. `.key` file).
 * If you choose to use __Key credentials__ you will have to provide:
 * @property teamId The ID assigned to your Apple developer account team. This value is provided on the Membership page.
 * @property tokenKey The `.p8` file that you download from your Apple developer account when you create an authentication key.
 * @property tokenKeyId The ID assigned to your signing key. To find this value, choose Certificates, IDs & Profiles, and choose your key in the Keys section.
 */
public data class ApnsVoipSandboxChannelArgs(
    public val applicationId: Output<String>? = null,
    public val bundleId: Output<String>? = null,
    public val certificate: Output<String>? = null,
    public val defaultAuthenticationMethod: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val privateKey: Output<String>? = null,
    public val teamId: Output<String>? = null,
    public val tokenKey: Output<String>? = null,
    public val tokenKeyId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.pinpoint.ApnsVoipSandboxChannelArgs> {
    override fun toJava(): com.pulumi.aws.pinpoint.ApnsVoipSandboxChannelArgs =
        com.pulumi.aws.pinpoint.ApnsVoipSandboxChannelArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .bundleId(bundleId?.applyValue({ args0 -> args0 }))
            .certificate(certificate?.applyValue({ args0 -> args0 }))
            .defaultAuthenticationMethod(defaultAuthenticationMethod?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .privateKey(privateKey?.applyValue({ args0 -> args0 }))
            .teamId(teamId?.applyValue({ args0 -> args0 }))
            .tokenKey(tokenKey?.applyValue({ args0 -> args0 }))
            .tokenKeyId(tokenKeyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApnsVoipSandboxChannelArgs].
 */
@PulumiTagMarker
public class ApnsVoipSandboxChannelArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var bundleId: Output<String>? = null

    private var certificate: Output<String>? = null

    private var defaultAuthenticationMethod: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var privateKey: Output<String>? = null

    private var teamId: Output<String>? = null

    private var tokenKey: Output<String>? = null

    private var tokenKeyId: Output<String>? = null

    /**
     * @param value The application ID.
     */
    @JvmName("igkimksptvjnupyk")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value The ID assigned to your iOS app. To find this value, choose Certificates, IDs & Profiles, choose App IDs in the Identifiers section, and choose your app.
     */
    @JvmName("nfrcncxmnowqmjex")
    public suspend fun bundleId(`value`: Output<String>) {
        this.bundleId = value
    }

    /**
     * @param value The pem encoded TLS Certificate from Apple.
     */
    @JvmName("qcgytycykuimofgf")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value The default authentication method used for APNs.
     * __NOTE__: Amazon Pinpoint uses this default for every APNs push notification that you send using the console.
     * You can override the default when you send a message programmatically using the Amazon Pinpoint API, the AWS CLI, or an AWS SDK.
     * If your default authentication type fails, Amazon Pinpoint doesn't attempt to use the other authentication type.
     * One of the following sets of credentials is also required.
     * If you choose to use __Certificate credentials__ you will have to provide:
     */
    @JvmName("wbnkoucthmmssyri")
    public suspend fun defaultAuthenticationMethod(`value`: Output<String>) {
        this.defaultAuthenticationMethod = value
    }

    /**
     * @param value Whether the channel is enabled or disabled. Defaults to `true`.
     */
    @JvmName("atxfvimhlxtukhmu")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The Certificate Private Key file (ie. `.key` file).
     * If you choose to use __Key credentials__ you will have to provide:
     */
    @JvmName("nylypaevvcfpkygr")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value The ID assigned to your Apple developer account team. This value is provided on the Membership page.
     */
    @JvmName("plaxvwceybidtcov")
    public suspend fun teamId(`value`: Output<String>) {
        this.teamId = value
    }

    /**
     * @param value The `.p8` file that you download from your Apple developer account when you create an authentication key.
     */
    @JvmName("pixepsuavlwnonxa")
    public suspend fun tokenKey(`value`: Output<String>) {
        this.tokenKey = value
    }

    /**
     * @param value The ID assigned to your signing key. To find this value, choose Certificates, IDs & Profiles, and choose your key in the Keys section.
     */
    @JvmName("qucdowctxmgaqxed")
    public suspend fun tokenKeyId(`value`: Output<String>) {
        this.tokenKeyId = value
    }

    /**
     * @param value The application ID.
     */
    @JvmName("adrugwvptfmdlwew")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value The ID assigned to your iOS app. To find this value, choose Certificates, IDs & Profiles, choose App IDs in the Identifiers section, and choose your app.
     */
    @JvmName("ykpwbefbyyknuhmt")
    public suspend fun bundleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bundleId = mapped
    }

    /**
     * @param value The pem encoded TLS Certificate from Apple.
     */
    @JvmName("swtknlvjjsevgegr")
    public suspend fun certificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value The default authentication method used for APNs.
     * __NOTE__: Amazon Pinpoint uses this default for every APNs push notification that you send using the console.
     * You can override the default when you send a message programmatically using the Amazon Pinpoint API, the AWS CLI, or an AWS SDK.
     * If your default authentication type fails, Amazon Pinpoint doesn't attempt to use the other authentication type.
     * One of the following sets of credentials is also required.
     * If you choose to use __Certificate credentials__ you will have to provide:
     */
    @JvmName("icmeaoytlwcabeea")
    public suspend fun defaultAuthenticationMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAuthenticationMethod = mapped
    }

    /**
     * @param value Whether the channel is enabled or disabled. Defaults to `true`.
     */
    @JvmName("tjphwpoyvjmbwwej")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The Certificate Private Key file (ie. `.key` file).
     * If you choose to use __Key credentials__ you will have to provide:
     */
    @JvmName("ohucgqnhxacjrxof")
    public suspend fun privateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value The ID assigned to your Apple developer account team. This value is provided on the Membership page.
     */
    @JvmName("kkroftjtxaejjopd")
    public suspend fun teamId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.teamId = mapped
    }

    /**
     * @param value The `.p8` file that you download from your Apple developer account when you create an authentication key.
     */
    @JvmName("esakktvmxstjtfdc")
    public suspend fun tokenKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenKey = mapped
    }

    /**
     * @param value The ID assigned to your signing key. To find this value, choose Certificates, IDs & Profiles, and choose your key in the Keys section.
     */
    @JvmName("hndtvsdddurdpntj")
    public suspend fun tokenKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenKeyId = mapped
    }

    internal fun build(): ApnsVoipSandboxChannelArgs = ApnsVoipSandboxChannelArgs(
        applicationId = applicationId,
        bundleId = bundleId,
        certificate = certificate,
        defaultAuthenticationMethod = defaultAuthenticationMethod,
        enabled = enabled,
        privateKey = privateKey,
        teamId = teamId,
        tokenKey = tokenKey,
        tokenKeyId = tokenKeyId,
    )
}
