@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.aws.pinpoint.kotlin.outputs.AppCampaignHook
import com.pulumi.aws.pinpoint.kotlin.outputs.AppLimits
import com.pulumi.aws.pinpoint.kotlin.outputs.AppQuietTime
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.pinpoint.kotlin.outputs.AppCampaignHook.Companion.toKotlin as appCampaignHookToKotlin
import com.pulumi.aws.pinpoint.kotlin.outputs.AppLimits.Companion.toKotlin as appLimitsToKotlin
import com.pulumi.aws.pinpoint.kotlin.outputs.AppQuietTime.Companion.toKotlin as appQuietTimeToKotlin

/**
 * Builder for [App].
 */
@PulumiTagMarker
public class AppResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppArgs = AppArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppArgsBuilder.() -> Unit) {
        val builder = AppArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): App {
        val builtJavaResource = com.pulumi.aws.pinpoint.App(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return App(builtJavaResource)
    }
}

/**
 * Provides a Pinpoint App resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.AppArgs;
 * import com.pulumi.aws.pinpoint.inputs.AppLimitsArgs;
 * import com.pulumi.aws.pinpoint.inputs.AppQuietTimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .limits(AppLimitsArgs.builder()
 *                 .maximumDuration(600)
 *                 .build())
 *             .quietTime(AppQuietTimeArgs.builder()
 *                 .end("06:00")
 *                 .start("00:00")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Pinpoint App using the `application-id`. For example:
 * ```sh
 *  $ pulumi import aws:pinpoint/app:App name application-id
 * ```
 *
 */
public class App internal constructor(
    override val javaResource: com.pulumi.aws.pinpoint.App,
) : KotlinCustomResource(javaResource, AppMapper) {
    /**
     * The Application ID of the Pinpoint App.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the PinPoint Application
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies settings for invoking an AWS Lambda function that customizes a segment for a campaign
     */
    public val campaignHook: Output<AppCampaignHook>?
        get() = javaResource.campaignHook().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    appCampaignHookToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The default campaign limits for the app. These limits apply to each campaign for the app, unless the campaign overrides the default with limits of its own
     */
    public val limits: Output<AppLimits>?
        get() = javaResource.limits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    appLimitsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The application name. By default generated by Pulumi
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the Pinpoint application. Conflicts with `name`
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * The default quiet time for the app. Each campaign for this app sends no messages during this time unless the campaign overrides the default with a quiet time of its own
     */
    public val quietTime: Output<AppQuietTime>?
        get() = javaResource.quietTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    appQuietTimeToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AppMapper : ResourceMapper<App> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.pinpoint.App::class == javaResource::class

    override fun map(javaResource: Resource): App = App(javaResource as com.pulumi.aws.pinpoint.App)
}

/**
 * @see [App].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [App].
 */
public suspend fun app(name: String, block: suspend AppResourceBuilder.() -> Unit): App {
    val builder = AppResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [App].
 * @param name The _unique_ name of the resulting resource.
 */
public fun app(name: String): App {
    val builder = AppResourceBuilder()
    builder.name(name)
    return builder.build()
}
