@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.aws.pinpoint.AppArgs.builder
import com.pulumi.aws.pinpoint.kotlin.inputs.AppCampaignHookArgs
import com.pulumi.aws.pinpoint.kotlin.inputs.AppCampaignHookArgsBuilder
import com.pulumi.aws.pinpoint.kotlin.inputs.AppLimitsArgs
import com.pulumi.aws.pinpoint.kotlin.inputs.AppLimitsArgsBuilder
import com.pulumi.aws.pinpoint.kotlin.inputs.AppQuietTimeArgs
import com.pulumi.aws.pinpoint.kotlin.inputs.AppQuietTimeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Pinpoint App resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.AppArgs;
 * import com.pulumi.aws.pinpoint.inputs.AppLimitsArgs;
 * import com.pulumi.aws.pinpoint.inputs.AppQuietTimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .limits(AppLimitsArgs.builder()
 *                 .maximumDuration(600)
 *                 .build())
 *             .quietTime(AppQuietTimeArgs.builder()
 *                 .end("06:00")
 *                 .start("00:00")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Pinpoint App using the `application-id`. For example:
 * ```sh
 *  $ pulumi import aws:pinpoint/app:App name application-id
 * ```
 * @property campaignHook Specifies settings for invoking an AWS Lambda function that customizes a segment for a campaign
 * @property limits The default campaign limits for the app. These limits apply to each campaign for the app, unless the campaign overrides the default with limits of its own
 * @property name The application name. By default generated by Pulumi
 * @property namePrefix The name of the Pinpoint application. Conflicts with `name`
 * @property quietTime The default quiet time for the app. Each campaign for this app sends no messages during this time unless the campaign overrides the default with a quiet time of its own
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AppArgs(
    public val campaignHook: Output<AppCampaignHookArgs>? = null,
    public val limits: Output<AppLimitsArgs>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val quietTime: Output<AppQuietTimeArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.pinpoint.AppArgs> {
    override fun toJava(): com.pulumi.aws.pinpoint.AppArgs = com.pulumi.aws.pinpoint.AppArgs.builder()
        .campaignHook(campaignHook?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .limits(limits?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .name(name?.applyValue({ args0 -> args0 }))
        .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
        .quietTime(quietTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [AppArgs].
 */
@PulumiTagMarker
public class AppArgsBuilder internal constructor() {
    private var campaignHook: Output<AppCampaignHookArgs>? = null

    private var limits: Output<AppLimitsArgs>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var quietTime: Output<AppQuietTimeArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies settings for invoking an AWS Lambda function that customizes a segment for a campaign
     */
    @JvmName("kcabuvtarlntocpb")
    public suspend fun campaignHook(`value`: Output<AppCampaignHookArgs>) {
        this.campaignHook = value
    }

    /**
     * @param value The default campaign limits for the app. These limits apply to each campaign for the app, unless the campaign overrides the default with limits of its own
     */
    @JvmName("mwrswakgwlgibnud")
    public suspend fun limits(`value`: Output<AppLimitsArgs>) {
        this.limits = value
    }

    /**
     * @param value The application name. By default generated by Pulumi
     */
    @JvmName("ngffxyttketqeobc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the Pinpoint application. Conflicts with `name`
     */
    @JvmName("pjnjnefgnredyyic")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The default quiet time for the app. Each campaign for this app sends no messages during this time unless the campaign overrides the default with a quiet time of its own
     */
    @JvmName("tkrdxfabpwrdeshp")
    public suspend fun quietTime(`value`: Output<AppQuietTimeArgs>) {
        this.quietTime = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wtliryfbxawovhsk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies settings for invoking an AWS Lambda function that customizes a segment for a campaign
     */
    @JvmName("kqotvaqojtlrtkbg")
    public suspend fun campaignHook(`value`: AppCampaignHookArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.campaignHook = mapped
    }

    /**
     * @param argument Specifies settings for invoking an AWS Lambda function that customizes a segment for a campaign
     */
    @JvmName("idkxakglxtufgyjt")
    public suspend fun campaignHook(argument: suspend AppCampaignHookArgsBuilder.() -> Unit) {
        val toBeMapped = AppCampaignHookArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.campaignHook = mapped
    }

    /**
     * @param value The default campaign limits for the app. These limits apply to each campaign for the app, unless the campaign overrides the default with limits of its own
     */
    @JvmName("kyqupsjwjddufvei")
    public suspend fun limits(`value`: AppLimitsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param argument The default campaign limits for the app. These limits apply to each campaign for the app, unless the campaign overrides the default with limits of its own
     */
    @JvmName("shmhworpnxlalegf")
    public suspend fun limits(argument: suspend AppLimitsArgsBuilder.() -> Unit) {
        val toBeMapped = AppLimitsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limits = mapped
    }

    /**
     * @param value The application name. By default generated by Pulumi
     */
    @JvmName("mrduormpqydwncos")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the Pinpoint application. Conflicts with `name`
     */
    @JvmName("eissubaojyxumewb")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The default quiet time for the app. Each campaign for this app sends no messages during this time unless the campaign overrides the default with a quiet time of its own
     */
    @JvmName("xwrrpupypeukcwre")
    public suspend fun quietTime(`value`: AppQuietTimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quietTime = mapped
    }

    /**
     * @param argument The default quiet time for the app. Each campaign for this app sends no messages during this time unless the campaign overrides the default with a quiet time of its own
     */
    @JvmName("kencntsylhxmpagk")
    public suspend fun quietTime(argument: suspend AppQuietTimeArgsBuilder.() -> Unit) {
        val toBeMapped = AppQuietTimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.quietTime = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wvagkshqsafpltya")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("argoqdpniagwhbfm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AppArgs = AppArgs(
        campaignHook = campaignHook,
        limits = limits,
        name = name,
        namePrefix = namePrefix,
        quietTime = quietTime,
        tags = tags,
    )
}
