@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.aws.pinpoint.BaiduChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Pinpoint Baidu Channel resource.
 * > **Note:** All arguments including the Api Key and Secret Key will be stored in the raw state as plain-text.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.BaiduChannel;
 * import com.pulumi.aws.pinpoint.BaiduChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         var channel = new BaiduChannel("channel", BaiduChannelArgs.builder()
 *             .applicationId(app.applicationId())
 *             .apiKey("")
 *             .secretKey("")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Pinpoint Baidu Channel using the `application-id`. For example:
 * ```sh
 *  $ pulumi import aws:pinpoint/baiduChannel:BaiduChannel channel application-id
 * ```
 * @property apiKey Platform credential API key from Baidu.
 * @property applicationId The application ID.
 * @property enabled Specifies whether to enable the channel. Defaults to `true`.
 * @property secretKey Platform credential Secret key from Baidu.
 */
public data class BaiduChannelArgs(
    public val apiKey: Output<String>? = null,
    public val applicationId: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val secretKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.pinpoint.BaiduChannelArgs> {
    override fun toJava(): com.pulumi.aws.pinpoint.BaiduChannelArgs =
        com.pulumi.aws.pinpoint.BaiduChannelArgs.builder()
            .apiKey(apiKey?.applyValue({ args0 -> args0 }))
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .secretKey(secretKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BaiduChannelArgs].
 */
@PulumiTagMarker
public class BaiduChannelArgsBuilder internal constructor() {
    private var apiKey: Output<String>? = null

    private var applicationId: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var secretKey: Output<String>? = null

    /**
     * @param value Platform credential API key from Baidu.
     */
    @JvmName("tguuynwvfynawjme")
    public suspend fun apiKey(`value`: Output<String>) {
        this.apiKey = value
    }

    /**
     * @param value The application ID.
     */
    @JvmName("kqoexnlyqyfkofvj")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Specifies whether to enable the channel. Defaults to `true`.
     */
    @JvmName("gypbymlkyvfivfal")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Platform credential Secret key from Baidu.
     */
    @JvmName("ovtbjqsbqjiadbyp")
    public suspend fun secretKey(`value`: Output<String>) {
        this.secretKey = value
    }

    /**
     * @param value Platform credential API key from Baidu.
     */
    @JvmName("dhymyidxvdicudyx")
    public suspend fun apiKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    /**
     * @param value The application ID.
     */
    @JvmName("atsmrgnscmouqiat")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Specifies whether to enable the channel. Defaults to `true`.
     */
    @JvmName("yjrbcuetmniqbyks")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Platform credential Secret key from Baidu.
     */
    @JvmName("oifkvgdlavaoaidj")
    public suspend fun secretKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretKey = mapped
    }

    internal fun build(): BaiduChannelArgs = BaiduChannelArgs(
        apiKey = apiKey,
        applicationId = applicationId,
        enabled = enabled,
        secretKey = secretKey,
    )
}
