@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EmailChannel].
 */
@PulumiTagMarker
public class EmailChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EmailChannelArgs = EmailChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EmailChannelArgsBuilder.() -> Unit) {
        val builder = EmailChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EmailChannel {
        val builtJavaResource = com.pulumi.aws.pinpoint.EmailChannel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EmailChannel(builtJavaResource)
    }
}

/**
 * Provides a Pinpoint Email Channel resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.pinpoint.EmailChannel;
 * import com.pulumi.aws.pinpoint.EmailChannelArgs;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("pinpoint.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var email = new EmailChannel("email", EmailChannelArgs.builder()
 *             .applicationId(app.applicationId())
 *             .fromAddress("user@example.com")
 *             .roleArn(role.arn())
 *             .build());
 *         var identity = new DomainIdentity("identity", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *         final var rolePolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "mobileanalytics:PutEvents",
 *                     "mobileanalytics:PutItems")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var rolePolicyRolePolicy = new RolePolicy("rolePolicyRolePolicy", RolePolicyArgs.builder()
 *             .role(role.id())
 *             .policy(rolePolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Pinpoint Email Channel using the `application-id`. For example:
 * ```sh
 *  $ pulumi import aws:pinpoint/emailChannel:EmailChannel email application-id
 * ```
 *
 */
public class EmailChannel internal constructor(
    override val javaResource: com.pulumi.aws.pinpoint.EmailChannel,
) : KotlinCustomResource(javaResource, EmailChannelMapper) {
    /**
     * The application ID.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * The ARN of the Amazon SES configuration set that you want to apply to messages that you send through the channel.
     */
    public val configurationSet: Output<String>?
        get() = javaResource.configurationSet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the channel is enabled or disabled. Defaults to `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The email address used to send emails from. You can use email only (`user@example.com`) or friendly address (`User <user@example.com>`). This field comply with [RFC 5322](https://www.ietf.org/rfc/rfc5322.txt).
     */
    public val fromAddress: Output<String>
        get() = javaResource.fromAddress().applyValue({ args0 -> args0 })

    /**
     * The ARN of an identity verified with SES.
     */
    public val identity: Output<String>
        get() = javaResource.identity().applyValue({ args0 -> args0 })

    /**
     * Messages per second that can be sent.
     */
    public val messagesPerSecond: Output<Int>
        get() = javaResource.messagesPerSecond().applyValue({ args0 -> args0 })

    /**
     * The ARN of an IAM Role used to submit events to Mobile Analytics' event ingestion service.
     */
    public val roleArn: Output<String>?
        get() = javaResource.roleArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object EmailChannelMapper : ResourceMapper<EmailChannel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.pinpoint.EmailChannel::class == javaResource::class

    override fun map(javaResource: Resource): EmailChannel = EmailChannel(
        javaResource as
            com.pulumi.aws.pinpoint.EmailChannel,
    )
}

/**
 * @see [EmailChannel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EmailChannel].
 */
public suspend fun emailChannel(
    name: String,
    block: suspend EmailChannelResourceBuilder.() -> Unit,
): EmailChannel {
    val builder = EmailChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EmailChannel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun emailChannel(name: String): EmailChannel {
    val builder = EmailChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
