@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.aws.pinpoint.EmailChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Pinpoint Email Channel resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.pinpoint.EmailChannel;
 * import com.pulumi.aws.pinpoint.EmailChannelArgs;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("pinpoint.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var email = new EmailChannel("email", EmailChannelArgs.builder()
 *             .applicationId(app.applicationId())
 *             .fromAddress("user@example.com")
 *             .roleArn(role.arn())
 *             .build());
 *         var identity = new DomainIdentity("identity", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *         final var rolePolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "mobileanalytics:PutEvents",
 *                     "mobileanalytics:PutItems")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var rolePolicyRolePolicy = new RolePolicy("rolePolicyRolePolicy", RolePolicyArgs.builder()
 *             .role(role.id())
 *             .policy(rolePolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Pinpoint Email Channel using the `application-id`. For example:
 * ```sh
 *  $ pulumi import aws:pinpoint/emailChannel:EmailChannel email application-id
 * ```
 * @property applicationId The application ID.
 * @property configurationSet The ARN of the Amazon SES configuration set that you want to apply to messages that you send through the channel.
 * @property enabled Whether the channel is enabled or disabled. Defaults to `true`.
 * @property fromAddress The email address used to send emails from. You can use email only (`user@example.com`) or friendly address (`User <user@example.com>`). This field comply with [RFC 5322](https://www.ietf.org/rfc/rfc5322.txt).
 * @property identity The ARN of an identity verified with SES.
 * @property roleArn The ARN of an IAM Role used to submit events to Mobile Analytics' event ingestion service.
 */
public data class EmailChannelArgs(
    public val applicationId: Output<String>? = null,
    public val configurationSet: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val fromAddress: Output<String>? = null,
    public val identity: Output<String>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.pinpoint.EmailChannelArgs> {
    override fun toJava(): com.pulumi.aws.pinpoint.EmailChannelArgs =
        com.pulumi.aws.pinpoint.EmailChannelArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .configurationSet(configurationSet?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .fromAddress(fromAddress?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EmailChannelArgs].
 */
@PulumiTagMarker
public class EmailChannelArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var configurationSet: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var fromAddress: Output<String>? = null

    private var identity: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The application ID.
     */
    @JvmName("poctiocoxebamimd")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value The ARN of the Amazon SES configuration set that you want to apply to messages that you send through the channel.
     */
    @JvmName("nhsikpnokvjxagxl")
    public suspend fun configurationSet(`value`: Output<String>) {
        this.configurationSet = value
    }

    /**
     * @param value Whether the channel is enabled or disabled. Defaults to `true`.
     */
    @JvmName("huxbuiujjigguinr")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The email address used to send emails from. You can use email only (`user@example.com`) or friendly address (`User <user@example.com>`). This field comply with [RFC 5322](https://www.ietf.org/rfc/rfc5322.txt).
     */
    @JvmName("dofdlhdgwtoqgeky")
    public suspend fun fromAddress(`value`: Output<String>) {
        this.fromAddress = value
    }

    /**
     * @param value The ARN of an identity verified with SES.
     */
    @JvmName("gakpxeginggupmej")
    public suspend fun identity(`value`: Output<String>) {
        this.identity = value
    }

    /**
     * @param value The ARN of an IAM Role used to submit events to Mobile Analytics' event ingestion service.
     */
    @JvmName("aovydtkukqsdeofv")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The application ID.
     */
    @JvmName("ehwhawmqhevbbomb")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value The ARN of the Amazon SES configuration set that you want to apply to messages that you send through the channel.
     */
    @JvmName("stehlkmfgstidtqi")
    public suspend fun configurationSet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationSet = mapped
    }

    /**
     * @param value Whether the channel is enabled or disabled. Defaults to `true`.
     */
    @JvmName("ukexcdtgakoexkva")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The email address used to send emails from. You can use email only (`user@example.com`) or friendly address (`User <user@example.com>`). This field comply with [RFC 5322](https://www.ietf.org/rfc/rfc5322.txt).
     */
    @JvmName("vejdkolxjowwcoym")
    public suspend fun fromAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromAddress = mapped
    }

    /**
     * @param value The ARN of an identity verified with SES.
     */
    @JvmName("yxtvxlskqtopleeu")
    public suspend fun identity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param value The ARN of an IAM Role used to submit events to Mobile Analytics' event ingestion service.
     */
    @JvmName("cuidsfuorxqgosbq")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): EmailChannelArgs = EmailChannelArgs(
        applicationId = applicationId,
        configurationSet = configurationSet,
        enabled = enabled,
        fromAddress = fromAddress,
        identity = identity,
        roleArn = roleArn,
    )
}
