@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EventStream].
 */
@PulumiTagMarker
public class EventStreamResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventStreamArgs = EventStreamArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventStreamArgsBuilder.() -> Unit) {
        val builder = EventStreamArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EventStream {
        val builtJavaResource = com.pulumi.aws.pinpoint.EventStream(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventStream(builtJavaResource)
    }
}

/**
 *  /*
 * Provides a Pinpoint Event Stream resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.pinpoint.EventStream;
 * import com.pulumi.aws.pinpoint.EventStreamArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         var testStream = new Stream("testStream", StreamArgs.builder()
 *             .shardCount(1)
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("pinpoint.us-east-1.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var stream = new EventStream("stream", EventStreamArgs.builder()
 *             .applicationId(app.applicationId())
 *             .destinationStreamArn(testStream.arn())
 *             .roleArn(testRole.arn())
 *             .build());
 *         final var testRolePolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "kinesis:PutRecords",
 *                     "kinesis:DescribeStream")
 *                 .resources("arn:aws:kinesis:us-east-1:*:*/*")
 *                 .build())
 *             .build());
 *         var testRolePolicyRolePolicy = new RolePolicy("testRolePolicyRolePolicy", RolePolicyArgs.builder()
 *             .role(testRole.id())
 *             .policy(testRolePolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Pinpoint Event Stream using the `application-id`. For example:
 * ```sh
 *  $ pulumi import aws:pinpoint/eventStream:EventStream stream application-id
 * ```
 *
 */
public class EventStream internal constructor(
    override val javaResource: com.pulumi.aws.pinpoint.EventStream,
) : KotlinCustomResource(javaResource, EventStreamMapper) {
    /**
     * The application ID.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery stream to which you want to publish events.
     */
    public val destinationStreamArn: Output<String>
        get() = javaResource.destinationStreamArn().applyValue({ args0 -> args0 })

    /**
     * The IAM role that authorizes Amazon Pinpoint to publish events to the stream in your account.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })
}

public object EventStreamMapper : ResourceMapper<EventStream> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.pinpoint.EventStream::class == javaResource::class

    override fun map(javaResource: Resource): EventStream = EventStream(
        javaResource as
            com.pulumi.aws.pinpoint.EventStream,
    )
}

/**
 * @see [EventStream].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventStream].
 */
public suspend fun eventStream(name: String, block: suspend EventStreamResourceBuilder.() -> Unit):
    EventStream {
    val builder = EventStreamResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventStream].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventStream(name: String): EventStream {
    val builder = EventStreamResourceBuilder()
    builder.name(name)
    return builder.build()
}
