@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.aws.pinpoint.EventStreamArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *  /*
 * Provides a Pinpoint Event Stream resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.pinpoint.EventStream;
 * import com.pulumi.aws.pinpoint.EventStreamArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         var testStream = new Stream("testStream", StreamArgs.builder()
 *             .shardCount(1)
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("pinpoint.us-east-1.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var stream = new EventStream("stream", EventStreamArgs.builder()
 *             .applicationId(app.applicationId())
 *             .destinationStreamArn(testStream.arn())
 *             .roleArn(testRole.arn())
 *             .build());
 *         final var testRolePolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "kinesis:PutRecords",
 *                     "kinesis:DescribeStream")
 *                 .resources("arn:aws:kinesis:us-east-1:*:*/*")
 *                 .build())
 *             .build());
 *         var testRolePolicyRolePolicy = new RolePolicy("testRolePolicyRolePolicy", RolePolicyArgs.builder()
 *             .role(testRole.id())
 *             .policy(testRolePolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Pinpoint Event Stream using the `application-id`. For example:
 * ```sh
 *  $ pulumi import aws:pinpoint/eventStream:EventStream stream application-id
 * ```
 * @property applicationId The application ID.
 * @property destinationStreamArn The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery stream to which you want to publish events.
 * @property roleArn The IAM role that authorizes Amazon Pinpoint to publish events to the stream in your account.
 */
public data class EventStreamArgs(
    public val applicationId: Output<String>? = null,
    public val destinationStreamArn: Output<String>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.pinpoint.EventStreamArgs> {
    override fun toJava(): com.pulumi.aws.pinpoint.EventStreamArgs =
        com.pulumi.aws.pinpoint.EventStreamArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .destinationStreamArn(destinationStreamArn?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventStreamArgs].
 */
@PulumiTagMarker
public class EventStreamArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var destinationStreamArn: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The application ID.
     */
    @JvmName("ojkbgidkjvepkmbg")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery stream to which you want to publish events.
     */
    @JvmName("nugrrndbcgkmxvry")
    public suspend fun destinationStreamArn(`value`: Output<String>) {
        this.destinationStreamArn = value
    }

    /**
     * @param value The IAM role that authorizes Amazon Pinpoint to publish events to the stream in your account.
     */
    @JvmName("womclygthstcjyjk")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The application ID.
     */
    @JvmName("knfwpqgdirkljfpk")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery stream to which you want to publish events.
     */
    @JvmName("lvunywmhclcgowdq")
    public suspend fun destinationStreamArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationStreamArn = mapped
    }

    /**
     * @param value The IAM role that authorizes Amazon Pinpoint to publish events to the stream in your account.
     */
    @JvmName("puyebnbnwiqiijrj")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): EventStreamArgs = EventStreamArgs(
        applicationId = applicationId,
        destinationStreamArn = destinationStreamArn,
        roleArn = roleArn,
    )
}
