@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GcmChannel].
 */
@PulumiTagMarker
public class GcmChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GcmChannelArgs = GcmChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GcmChannelArgsBuilder.() -> Unit) {
        val builder = GcmChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GcmChannel {
        val builtJavaResource = com.pulumi.aws.pinpoint.GcmChannel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GcmChannel(builtJavaResource)
    }
}

/**
 * Provides a Pinpoint GCM Channel resource.
 * > **Note:** Api Key argument will be stored in the raw state as plain-text.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.GcmChannel;
 * import com.pulumi.aws.pinpoint.GcmChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         var gcm = new GcmChannel("gcm", GcmChannelArgs.builder()
 *             .applicationId(app.applicationId())
 *             .apiKey("api_key")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Pinpoint GCM Channel using the `application-id`. For example:
 * ```sh
 *  $ pulumi import aws:pinpoint/gcmChannel:GcmChannel gcm application-id
 * ```
 *
 */
public class GcmChannel internal constructor(
    override val javaResource: com.pulumi.aws.pinpoint.GcmChannel,
) : KotlinCustomResource(javaResource, GcmChannelMapper) {
    /**
     * Platform credential API key from Google.
     */
    public val apiKey: Output<String>
        get() = javaResource.apiKey().applyValue({ args0 -> args0 })

    /**
     * The application ID.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * Whether the channel is enabled or disabled. Defaults to `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object GcmChannelMapper : ResourceMapper<GcmChannel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.pinpoint.GcmChannel::class == javaResource::class

    override fun map(javaResource: Resource): GcmChannel = GcmChannel(
        javaResource as
            com.pulumi.aws.pinpoint.GcmChannel,
    )
}

/**
 * @see [GcmChannel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GcmChannel].
 */
public suspend fun gcmChannel(name: String, block: suspend GcmChannelResourceBuilder.() -> Unit):
    GcmChannel {
    val builder = GcmChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GcmChannel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gcmChannel(name: String): GcmChannel {
    val builder = GcmChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
