@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SmsChannel].
 */
@PulumiTagMarker
public class SmsChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SmsChannelArgs = SmsChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SmsChannelArgsBuilder.() -> Unit) {
        val builder = SmsChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SmsChannel {
        val builtJavaResource = com.pulumi.aws.pinpoint.SmsChannel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SmsChannel(builtJavaResource)
    }
}

/**
 * Use the `aws.pinpoint.SmsChannel` resource to manage Pinpoint SMS Channels.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.SmsChannel;
 * import com.pulumi.aws.pinpoint.SmsChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         var sms = new SmsChannel("sms", SmsChannelArgs.builder()
 *             .applicationId(app.applicationId())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the Pinpoint SMS Channel using the `application_id`. For example:
 * ```sh
 *  $ pulumi import aws:pinpoint/smsChannel:SmsChannel sms application-id
 * ```
 *
 */
public class SmsChannel internal constructor(
    override val javaResource: com.pulumi.aws.pinpoint.SmsChannel,
) : KotlinCustomResource(javaResource, SmsChannelMapper) {
    /**
     * ID of the application.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * Whether the channel is enabled or disabled. By default, it is set to `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Maximum number of promotional messages that can be sent per second.
     */
    public val promotionalMessagesPerSecond: Output<Int>
        get() = javaResource.promotionalMessagesPerSecond().applyValue({ args0 -> args0 })

    /**
     * Identifier of the sender for your messages.
     */
    public val senderId: Output<String>?
        get() = javaResource.senderId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Short Code registered with the phone provider.
     */
    public val shortCode: Output<String>?
        get() = javaResource.shortCode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Maximum number of transactional messages per second that can be sent.
     */
    public val transactionalMessagesPerSecond: Output<Int>
        get() = javaResource.transactionalMessagesPerSecond().applyValue({ args0 -> args0 })
}

public object SmsChannelMapper : ResourceMapper<SmsChannel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.pinpoint.SmsChannel::class == javaResource::class

    override fun map(javaResource: Resource): SmsChannel = SmsChannel(
        javaResource as
            com.pulumi.aws.pinpoint.SmsChannel,
    )
}

/**
 * @see [SmsChannel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SmsChannel].
 */
public suspend fun smsChannel(name: String, block: suspend SmsChannelResourceBuilder.() -> Unit):
    SmsChannel {
    val builder = SmsChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SmsChannel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun smsChannel(name: String): SmsChannel {
    val builder = SmsChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
