@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.aws.pinpoint.SmsChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Use the `aws.pinpoint.SmsChannel` resource to manage Pinpoint SMS Channels.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.SmsChannel;
 * import com.pulumi.aws.pinpoint.SmsChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         var sms = new SmsChannel("sms", SmsChannelArgs.builder()
 *             .applicationId(app.applicationId())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the Pinpoint SMS Channel using the `application_id`. For example:
 * ```sh
 *  $ pulumi import aws:pinpoint/smsChannel:SmsChannel sms application-id
 * ```
 * @property applicationId ID of the application.
 * @property enabled Whether the channel is enabled or disabled. By default, it is set to `true`.
 * @property senderId Identifier of the sender for your messages.
 * @property shortCode Short Code registered with the phone provider.
 */
public data class SmsChannelArgs(
    public val applicationId: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val senderId: Output<String>? = null,
    public val shortCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.pinpoint.SmsChannelArgs> {
    override fun toJava(): com.pulumi.aws.pinpoint.SmsChannelArgs =
        com.pulumi.aws.pinpoint.SmsChannelArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .senderId(senderId?.applyValue({ args0 -> args0 }))
            .shortCode(shortCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SmsChannelArgs].
 */
@PulumiTagMarker
public class SmsChannelArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var senderId: Output<String>? = null

    private var shortCode: Output<String>? = null

    /**
     * @param value ID of the application.
     */
    @JvmName("rihwkvhnydjruhvq")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Whether the channel is enabled or disabled. By default, it is set to `true`.
     */
    @JvmName("gpftyfnnlbjukhsn")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Identifier of the sender for your messages.
     */
    @JvmName("vepwvoynfhboxtql")
    public suspend fun senderId(`value`: Output<String>) {
        this.senderId = value
    }

    /**
     * @param value Short Code registered with the phone provider.
     */
    @JvmName("gljswttmplfkaacf")
    public suspend fun shortCode(`value`: Output<String>) {
        this.shortCode = value
    }

    /**
     * @param value ID of the application.
     */
    @JvmName("tqgwqyjdppfnetsi")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Whether the channel is enabled or disabled. By default, it is set to `true`.
     */
    @JvmName("lkwjqmdueglnhdoq")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Identifier of the sender for your messages.
     */
    @JvmName("fudgwknnspboealn")
    public suspend fun senderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.senderId = mapped
    }

    /**
     * @param value Short Code registered with the phone provider.
     */
    @JvmName("olhiwnmbqafmikxr")
    public suspend fun shortCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shortCode = mapped
    }

    internal fun build(): SmsChannelArgs = SmsChannelArgs(
        applicationId = applicationId,
        enabled = enabled,
        senderId = senderId,
        shortCode = shortCode,
    )
}
