@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin.inputs

import com.pulumi.aws.pinpoint.inputs.AppCampaignHookArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lambdaFunctionName Lambda function name or ARN to be called for delivery. Conflicts with `web_url`
 * @property mode What mode Lambda should be invoked in. Valid values for this parameter are `DELIVERY`, `FILTER`.
 * @property webUrl Web URL to call for hook. If the URL has authentication specified it will be added as authentication to the request. Conflicts with `lambda_function_name`
 */
public data class AppCampaignHookArgs(
    public val lambdaFunctionName: Output<String>? = null,
    public val mode: Output<String>? = null,
    public val webUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.pinpoint.inputs.AppCampaignHookArgs> {
    override fun toJava(): com.pulumi.aws.pinpoint.inputs.AppCampaignHookArgs =
        com.pulumi.aws.pinpoint.inputs.AppCampaignHookArgs.builder()
            .lambdaFunctionName(lambdaFunctionName?.applyValue({ args0 -> args0 }))
            .mode(mode?.applyValue({ args0 -> args0 }))
            .webUrl(webUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppCampaignHookArgs].
 */
@PulumiTagMarker
public class AppCampaignHookArgsBuilder internal constructor() {
    private var lambdaFunctionName: Output<String>? = null

    private var mode: Output<String>? = null

    private var webUrl: Output<String>? = null

    /**
     * @param value Lambda function name or ARN to be called for delivery. Conflicts with `web_url`
     */
    @JvmName("ncvwgesftaafwarx")
    public suspend fun lambdaFunctionName(`value`: Output<String>) {
        this.lambdaFunctionName = value
    }

    /**
     * @param value What mode Lambda should be invoked in. Valid values for this parameter are `DELIVERY`, `FILTER`.
     */
    @JvmName("uhfjeqpemdjwhjfi")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value Web URL to call for hook. If the URL has authentication specified it will be added as authentication to the request. Conflicts with `lambda_function_name`
     */
    @JvmName("mfbulvajkweuyhdw")
    public suspend fun webUrl(`value`: Output<String>) {
        this.webUrl = value
    }

    /**
     * @param value Lambda function name or ARN to be called for delivery. Conflicts with `web_url`
     */
    @JvmName("mmnfeleqmegaoqop")
    public suspend fun lambdaFunctionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaFunctionName = mapped
    }

    /**
     * @param value What mode Lambda should be invoked in. Valid values for this parameter are `DELIVERY`, `FILTER`.
     */
    @JvmName("auupvljyfglrntis")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Web URL to call for hook. If the URL has authentication specified it will be added as authentication to the request. Conflicts with `lambda_function_name`
     */
    @JvmName("fjrjwskxnmfphagm")
    public suspend fun webUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webUrl = mapped
    }

    internal fun build(): AppCampaignHookArgs = AppCampaignHookArgs(
        lambdaFunctionName = lambdaFunctionName,
        mode = mode,
        webUrl = webUrl,
    )
}
