@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin.inputs

import com.pulumi.aws.pinpoint.inputs.AppLimitsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property daily The maximum number of messages that the campaign can send daily.
 * @property maximumDuration The length of time (in seconds) that the campaign can run before it ends and message deliveries stop. This duration begins at the scheduled start time for the campaign. The minimum value is 60.
 * @property messagesPerSecond The number of messages that the campaign can send per second. The minimum value is 50, and the maximum is 20000.
 * @property total The maximum total number of messages that the campaign can send.
 */
public data class AppLimitsArgs(
    public val daily: Output<Int>? = null,
    public val maximumDuration: Output<Int>? = null,
    public val messagesPerSecond: Output<Int>? = null,
    public val total: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.pinpoint.inputs.AppLimitsArgs> {
    override fun toJava(): com.pulumi.aws.pinpoint.inputs.AppLimitsArgs =
        com.pulumi.aws.pinpoint.inputs.AppLimitsArgs.builder()
            .daily(daily?.applyValue({ args0 -> args0 }))
            .maximumDuration(maximumDuration?.applyValue({ args0 -> args0 }))
            .messagesPerSecond(messagesPerSecond?.applyValue({ args0 -> args0 }))
            .total(total?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppLimitsArgs].
 */
@PulumiTagMarker
public class AppLimitsArgsBuilder internal constructor() {
    private var daily: Output<Int>? = null

    private var maximumDuration: Output<Int>? = null

    private var messagesPerSecond: Output<Int>? = null

    private var total: Output<Int>? = null

    /**
     * @param value The maximum number of messages that the campaign can send daily.
     */
    @JvmName("cuccnkwehgdrdhrt")
    public suspend fun daily(`value`: Output<Int>) {
        this.daily = value
    }

    /**
     * @param value The length of time (in seconds) that the campaign can run before it ends and message deliveries stop. This duration begins at the scheduled start time for the campaign. The minimum value is 60.
     */
    @JvmName("gnoxiauwcquholet")
    public suspend fun maximumDuration(`value`: Output<Int>) {
        this.maximumDuration = value
    }

    /**
     * @param value The number of messages that the campaign can send per second. The minimum value is 50, and the maximum is 20000.
     */
    @JvmName("brjccxmuxuugjgeu")
    public suspend fun messagesPerSecond(`value`: Output<Int>) {
        this.messagesPerSecond = value
    }

    /**
     * @param value The maximum total number of messages that the campaign can send.
     */
    @JvmName("ttfracmtjseeruat")
    public suspend fun total(`value`: Output<Int>) {
        this.total = value
    }

    /**
     * @param value The maximum number of messages that the campaign can send daily.
     */
    @JvmName("cfwocqomhhmmhoey")
    public suspend fun daily(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daily = mapped
    }

    /**
     * @param value The length of time (in seconds) that the campaign can run before it ends and message deliveries stop. This duration begins at the scheduled start time for the campaign. The minimum value is 60.
     */
    @JvmName("xkraxiurtqxycefh")
    public suspend fun maximumDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumDuration = mapped
    }

    /**
     * @param value The number of messages that the campaign can send per second. The minimum value is 50, and the maximum is 20000.
     */
    @JvmName("fhywjlijnbotatjg")
    public suspend fun messagesPerSecond(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messagesPerSecond = mapped
    }

    /**
     * @param value The maximum total number of messages that the campaign can send.
     */
    @JvmName("dowgkeopljnnejfw")
    public suspend fun total(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.total = mapped
    }

    internal fun build(): AppLimitsArgs = AppLimitsArgs(
        daily = daily,
        maximumDuration = maximumDuration,
        messagesPerSecond = messagesPerSecond,
        total = total,
    )
}
