@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin.inputs

import com.pulumi.aws.pinpoint.inputs.AppQuietTimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property end The default end time for quiet time in ISO 8601 format. Required if `start` is set
 * @property start The default start time for quiet time in ISO 8601 format. Required if `end` is set
 */
public data class AppQuietTimeArgs(
    public val end: Output<String>? = null,
    public val start: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.pinpoint.inputs.AppQuietTimeArgs> {
    override fun toJava(): com.pulumi.aws.pinpoint.inputs.AppQuietTimeArgs =
        com.pulumi.aws.pinpoint.inputs.AppQuietTimeArgs.builder()
            .end(end?.applyValue({ args0 -> args0 }))
            .start(start?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppQuietTimeArgs].
 */
@PulumiTagMarker
public class AppQuietTimeArgsBuilder internal constructor() {
    private var end: Output<String>? = null

    private var start: Output<String>? = null

    /**
     * @param value The default end time for quiet time in ISO 8601 format. Required if `start` is set
     */
    @JvmName("uuroswdqaiwcgvxf")
    public suspend fun end(`value`: Output<String>) {
        this.end = value
    }

    /**
     * @param value The default start time for quiet time in ISO 8601 format. Required if `end` is set
     */
    @JvmName("mgucmwctgjqkvcqd")
    public suspend fun start(`value`: Output<String>) {
        this.start = value
    }

    /**
     * @param value The default end time for quiet time in ISO 8601 format. Required if `start` is set
     */
    @JvmName("tgeohfnxvxhtxbdk")
    public suspend fun end(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.end = mapped
    }

    /**
     * @param value The default start time for quiet time in ISO 8601 format. Required if `end` is set
     */
    @JvmName("logwclehpobwiemk")
    public suspend fun start(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.start = mapped
    }

    internal fun build(): AppQuietTimeArgs = AppQuietTimeArgs(
        end = end,
        start = start,
    )
}
