@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property daily The maximum number of messages that the campaign can send daily.
 * @property maximumDuration The length of time (in seconds) that the campaign can run before it ends and message deliveries stop. This duration begins at the scheduled start time for the campaign. The minimum value is 60.
 * @property messagesPerSecond The number of messages that the campaign can send per second. The minimum value is 50, and the maximum is 20000.
 * @property total The maximum total number of messages that the campaign can send.
 */
public data class AppLimits(
    public val daily: Int? = null,
    public val maximumDuration: Int? = null,
    public val messagesPerSecond: Int? = null,
    public val total: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pinpoint.outputs.AppLimits): AppLimits = AppLimits(
            daily = javaType.daily().map({ args0 -> args0 }).orElse(null),
            maximumDuration = javaType.maximumDuration().map({ args0 -> args0 }).orElse(null),
            messagesPerSecond = javaType.messagesPerSecond().map({ args0 -> args0 }).orElse(null),
            total = javaType.total().map({ args0 -> args0 }).orElse(null),
        )
    }
}
