@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property end The default end time for quiet time in ISO 8601 format. Required if `start` is set
 * @property start The default start time for quiet time in ISO 8601 format. Required if `end` is set
 */
public data class AppQuietTime(
    public val end: String? = null,
    public val start: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pinpoint.outputs.AppQuietTime): AppQuietTime =
            AppQuietTime(
                end = javaType.end().map({ args0 -> args0 }).orElse(null),
                start = javaType.start().map({ args0 -> args0 }).orElse(null),
            )
    }
}
