@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin

import com.pulumi.aws.pipes.kotlin.outputs.PipeEnrichmentParameters
import com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParameters
import com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParameters
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.pipes.kotlin.outputs.PipeEnrichmentParameters.Companion.toKotlin as pipeEnrichmentParametersToKotlin
import com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParameters.Companion.toKotlin as pipeSourceParametersToKotlin
import com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParameters.Companion.toKotlin as pipeTargetParametersToKotlin

/**
 * Builder for [Pipe].
 */
@PulumiTagMarker
public class PipeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipeArgs = PipeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipeArgsBuilder.() -> Unit) {
        val builder = PipeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Pipe {
        val builtJavaResource = com.pulumi.aws.pipes.Pipe(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Pipe(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS EventBridge Pipes Pipe.
 * You can find out more about EventBridge Pipes in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html).
 * EventBridge Pipes are very configurable, and may require IAM permissions to work correctly. More information on the configuration options and IAM permissions can be found in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html).
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.pipes.Pipe;
 * import com.pulumi.aws.pipes.PipeArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var main = AwsFunctions.getCallerIdentity();
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "pipes.amazonaws.com")
 *                         )),
 *                         jsonProperty("Condition", jsonObject(
 *                             jsonProperty("StringEquals", jsonObject(
 *                                 jsonProperty("aws:SourceAccount", main.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *         var sourceQueue = new Queue("sourceQueue");
 *         var sourceRolePolicy = new RolePolicy("sourceRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.id())
 *             .policy(sourceQueue.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", jsonArray(
 *                             "sqs:DeleteMessage",
 *                             "sqs:GetQueueAttributes",
 *                             "sqs:ReceiveMessage"
 *                         )),
 *                         jsonProperty("Resource", jsonArray(arn))
 *                     )))
 *                 ))))
 *             .build());
 *         var targetQueue = new Queue("targetQueue");
 *         var targetRolePolicy = new RolePolicy("targetRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.id())
 *             .policy(targetQueue.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", jsonArray("sqs:SendMessage")),
 *                         jsonProperty("Resource", jsonArray(arn))
 *                     )))
 *                 ))))
 *             .build());
 *         var examplePipe = new Pipe("examplePipe", PipeArgs.builder()
 *             .roleArn(exampleRole.arn())
 *             .source(sourceQueue.arn())
 *             .target(targetQueue.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     sourceRolePolicy,
 *                     targetRolePolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ### Enrichment Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pipes.Pipe;
 * import com.pulumi.aws.pipes.PipeArgs;
 * import com.pulumi.aws.pipes.inputs.PipeEnrichmentParametersArgs;
 * import com.pulumi.aws.pipes.inputs.PipeEnrichmentParametersHttpParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Pipe("example", PipeArgs.builder()
 *             .roleArn(aws_iam_role.example().arn())
 *             .source(aws_sqs_queue.source().arn())
 *             .target(aws_sqs_queue.target().arn())
 *             .enrichment(aws_cloudwatch_event_api_destination.example().arn())
 *             .enrichmentParameters(PipeEnrichmentParametersArgs.builder()
 *                 .httpParameters(PipeEnrichmentParametersHttpParametersArgs.builder()
 *                     .pathParameterValues("example-path-param")
 *                     .headerParameters(Map.ofEntries(
 *                         Map.entry("example-header", "example-value"),
 *                         Map.entry("second-example-header", "second-example-value")
 *                     ))
 *                     .queryStringParameters(Map.ofEntries(
 *                         Map.entry("example-query-string", "example-value"),
 *                         Map.entry("second-example-query-string", "second-example-value")
 *                     ))
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Filter Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pipes.Pipe;
 * import com.pulumi.aws.pipes.PipeArgs;
 * import com.pulumi.aws.pipes.inputs.PipeSourceParametersArgs;
 * import com.pulumi.aws.pipes.inputs.PipeSourceParametersFilterCriteriaArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Pipe("example", PipeArgs.builder()
 *             .roleArn(aws_iam_role.example().arn())
 *             .source(aws_sqs_queue.source().arn())
 *             .target(aws_sqs_queue.target().arn())
 *             .sourceParameters(PipeSourceParametersArgs.builder()
 *                 .filterCriteria(PipeSourceParametersFilterCriteriaArgs.builder()
 *                     .filters(PipeSourceParametersFilterCriteriaFilterArgs.builder()
 *                         .pattern(serializeJson(
 *                             jsonObject(
 *                                 jsonProperty("source", jsonArray("event-source"))
 *                             )))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### SQS Source and Target Configuration Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pipes.Pipe;
 * import com.pulumi.aws.pipes.PipeArgs;
 * import com.pulumi.aws.pipes.inputs.PipeSourceParametersArgs;
 * import com.pulumi.aws.pipes.inputs.PipeSourceParametersSqsQueueParametersArgs;
 * import com.pulumi.aws.pipes.inputs.PipeTargetParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Pipe("example", PipeArgs.builder()
 *             .roleArn(aws_iam_role.example().arn())
 *             .source(aws_sqs_queue.source().arn())
 *             .target(aws_sqs_queue.target().arn())
 *             .sourceParameters(PipeSourceParametersArgs.builder()
 *                 .sqsQueueParameters(PipeSourceParametersSqsQueueParametersArgs.builder()
 *                     .batchSize(1)
 *                     .maximumBatchingWindowInSeconds(2)
 *                     .build())
 *                 .build())
 *             .targetParameters(PipeTargetParametersArgs.builder()
 *                 .sqsQueue(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import pipes using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:pipes/pipe:Pipe example my-pipe
 * ```
 *
 */
public class Pipe internal constructor(
    override val javaResource: com.pulumi.aws.pipes.Pipe,
) : KotlinCustomResource(javaResource, PipeMapper) {
    /**
     * The ARN of the Amazon SQS queue specified as the target for the dead-letter queue.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description of the pipe. At most 512 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state the pipe should be in. One of: `RUNNING`, `STOPPED`.
     */
    public val desiredState: Output<String>?
        get() = javaResource.desiredState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enrichment resource of the pipe (typically an ARN). Read more about enrichment in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-enrichment).
     */
    public val enrichment: Output<String>?
        get() = javaResource.enrichment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Parameters to configure enrichment for your pipe. Detailed below.
     */
    public val enrichmentParameters: Output<PipeEnrichmentParameters>?
        get() = javaResource.enrichmentParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> pipeEnrichmentParametersToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * ARN of the role that allows the pipe to send data to the target.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * Source resource of the pipe (typically an ARN).
     */
    public val source: Output<String>
        get() = javaResource.source().applyValue({ args0 -> args0 })

    /**
     * Parameters to configure a source for the pipe. Detailed below.
     */
    public val sourceParameters: Output<PipeSourceParameters>
        get() = javaResource.sourceParameters().applyValue({ args0 ->
            args0.let({ args0 ->
                pipeSourceParametersToKotlin(args0)
            })
        })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Target resource of the pipe (typically an ARN).
     * The following arguments are optional:
     */
    public val target: Output<String>
        get() = javaResource.target().applyValue({ args0 -> args0 })

    /**
     * Parameters to configure a target for your pipe. Detailed below.
     */
    public val targetParameters: Output<PipeTargetParameters>?
        get() = javaResource.targetParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> pipeTargetParametersToKotlin(args0) })
            }).orElse(null)
        })
}

public object PipeMapper : ResourceMapper<Pipe> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.pipes.Pipe::class == javaResource::class

    override fun map(javaResource: Resource): Pipe = Pipe(javaResource as com.pulumi.aws.pipes.Pipe)
}

/**
 * @see [Pipe].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Pipe].
 */
public suspend fun pipe(name: String, block: suspend PipeResourceBuilder.() -> Unit): Pipe {
    val builder = PipeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Pipe].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipe(name: String): Pipe {
    val builder = PipeResourceBuilder()
    builder.name(name)
    return builder.build()
}
