@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin

import com.pulumi.aws.pipes.PipeArgs.builder
import com.pulumi.aws.pipes.kotlin.inputs.PipeEnrichmentParametersArgs
import com.pulumi.aws.pipes.kotlin.inputs.PipeEnrichmentParametersArgsBuilder
import com.pulumi.aws.pipes.kotlin.inputs.PipeSourceParametersArgs
import com.pulumi.aws.pipes.kotlin.inputs.PipeSourceParametersArgsBuilder
import com.pulumi.aws.pipes.kotlin.inputs.PipeTargetParametersArgs
import com.pulumi.aws.pipes.kotlin.inputs.PipeTargetParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS EventBridge Pipes Pipe.
 * You can find out more about EventBridge Pipes in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html).
 * EventBridge Pipes are very configurable, and may require IAM permissions to work correctly. More information on the configuration options and IAM permissions can be found in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html).
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.pipes.Pipe;
 * import com.pulumi.aws.pipes.PipeArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var main = AwsFunctions.getCallerIdentity();
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "pipes.amazonaws.com")
 *                         )),
 *                         jsonProperty("Condition", jsonObject(
 *                             jsonProperty("StringEquals", jsonObject(
 *                                 jsonProperty("aws:SourceAccount", main.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *         var sourceQueue = new Queue("sourceQueue");
 *         var sourceRolePolicy = new RolePolicy("sourceRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.id())
 *             .policy(sourceQueue.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", jsonArray(
 *                             "sqs:DeleteMessage",
 *                             "sqs:GetQueueAttributes",
 *                             "sqs:ReceiveMessage"
 *                         )),
 *                         jsonProperty("Resource", jsonArray(arn))
 *                     )))
 *                 ))))
 *             .build());
 *         var targetQueue = new Queue("targetQueue");
 *         var targetRolePolicy = new RolePolicy("targetRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.id())
 *             .policy(targetQueue.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", jsonArray("sqs:SendMessage")),
 *                         jsonProperty("Resource", jsonArray(arn))
 *                     )))
 *                 ))))
 *             .build());
 *         var examplePipe = new Pipe("examplePipe", PipeArgs.builder()
 *             .roleArn(exampleRole.arn())
 *             .source(sourceQueue.arn())
 *             .target(targetQueue.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     sourceRolePolicy,
 *                     targetRolePolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ### Enrichment Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pipes.Pipe;
 * import com.pulumi.aws.pipes.PipeArgs;
 * import com.pulumi.aws.pipes.inputs.PipeEnrichmentParametersArgs;
 * import com.pulumi.aws.pipes.inputs.PipeEnrichmentParametersHttpParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Pipe("example", PipeArgs.builder()
 *             .roleArn(aws_iam_role.example().arn())
 *             .source(aws_sqs_queue.source().arn())
 *             .target(aws_sqs_queue.target().arn())
 *             .enrichment(aws_cloudwatch_event_api_destination.example().arn())
 *             .enrichmentParameters(PipeEnrichmentParametersArgs.builder()
 *                 .httpParameters(PipeEnrichmentParametersHttpParametersArgs.builder()
 *                     .pathParameterValues("example-path-param")
 *                     .headerParameters(Map.ofEntries(
 *                         Map.entry("example-header", "example-value"),
 *                         Map.entry("second-example-header", "second-example-value")
 *                     ))
 *                     .queryStringParameters(Map.ofEntries(
 *                         Map.entry("example-query-string", "example-value"),
 *                         Map.entry("second-example-query-string", "second-example-value")
 *                     ))
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Filter Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pipes.Pipe;
 * import com.pulumi.aws.pipes.PipeArgs;
 * import com.pulumi.aws.pipes.inputs.PipeSourceParametersArgs;
 * import com.pulumi.aws.pipes.inputs.PipeSourceParametersFilterCriteriaArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Pipe("example", PipeArgs.builder()
 *             .roleArn(aws_iam_role.example().arn())
 *             .source(aws_sqs_queue.source().arn())
 *             .target(aws_sqs_queue.target().arn())
 *             .sourceParameters(PipeSourceParametersArgs.builder()
 *                 .filterCriteria(PipeSourceParametersFilterCriteriaArgs.builder()
 *                     .filters(PipeSourceParametersFilterCriteriaFilterArgs.builder()
 *                         .pattern(serializeJson(
 *                             jsonObject(
 *                                 jsonProperty("source", jsonArray("event-source"))
 *                             )))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### SQS Source and Target Configuration Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pipes.Pipe;
 * import com.pulumi.aws.pipes.PipeArgs;
 * import com.pulumi.aws.pipes.inputs.PipeSourceParametersArgs;
 * import com.pulumi.aws.pipes.inputs.PipeSourceParametersSqsQueueParametersArgs;
 * import com.pulumi.aws.pipes.inputs.PipeTargetParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Pipe("example", PipeArgs.builder()
 *             .roleArn(aws_iam_role.example().arn())
 *             .source(aws_sqs_queue.source().arn())
 *             .target(aws_sqs_queue.target().arn())
 *             .sourceParameters(PipeSourceParametersArgs.builder()
 *                 .sqsQueueParameters(PipeSourceParametersSqsQueueParametersArgs.builder()
 *                     .batchSize(1)
 *                     .maximumBatchingWindowInSeconds(2)
 *                     .build())
 *                 .build())
 *             .targetParameters(PipeTargetParametersArgs.builder()
 *                 .sqsQueue(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import pipes using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:pipes/pipe:Pipe example my-pipe
 * ```
 * @property description A description of the pipe. At most 512 characters.
 * @property desiredState The state the pipe should be in. One of: `RUNNING`, `STOPPED`.
 * @property enrichment Enrichment resource of the pipe (typically an ARN). Read more about enrichment in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-enrichment).
 * @property enrichmentParameters Parameters to configure enrichment for your pipe. Detailed below.
 * @property name Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property roleArn ARN of the role that allows the pipe to send data to the target.
 * @property source Source resource of the pipe (typically an ARN).
 * @property sourceParameters Parameters to configure a source for the pipe. Detailed below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property target Target resource of the pipe (typically an ARN).
 * The following arguments are optional:
 * @property targetParameters Parameters to configure a target for your pipe. Detailed below.
 */
public data class PipeArgs(
    public val description: Output<String>? = null,
    public val desiredState: Output<String>? = null,
    public val enrichment: Output<String>? = null,
    public val enrichmentParameters: Output<PipeEnrichmentParametersArgs>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val source: Output<String>? = null,
    public val sourceParameters: Output<PipeSourceParametersArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val target: Output<String>? = null,
    public val targetParameters: Output<PipeTargetParametersArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.PipeArgs> {
    override fun toJava(): com.pulumi.aws.pipes.PipeArgs = com.pulumi.aws.pipes.PipeArgs.builder()
        .description(description?.applyValue({ args0 -> args0 }))
        .desiredState(desiredState?.applyValue({ args0 -> args0 }))
        .enrichment(enrichment?.applyValue({ args0 -> args0 }))
        .enrichmentParameters(
            enrichmentParameters?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .name(name?.applyValue({ args0 -> args0 }))
        .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
        .roleArn(roleArn?.applyValue({ args0 -> args0 }))
        .source(source?.applyValue({ args0 -> args0 }))
        .sourceParameters(sourceParameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .target(target?.applyValue({ args0 -> args0 }))
        .targetParameters(
            targetParameters?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        ).build()
}

/**
 * Builder for [PipeArgs].
 */
@PulumiTagMarker
public class PipeArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var desiredState: Output<String>? = null

    private var enrichment: Output<String>? = null

    private var enrichmentParameters: Output<PipeEnrichmentParametersArgs>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var source: Output<String>? = null

    private var sourceParameters: Output<PipeSourceParametersArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var target: Output<String>? = null

    private var targetParameters: Output<PipeTargetParametersArgs>? = null

    /**
     * @param value A description of the pipe. At most 512 characters.
     */
    @JvmName("ssjvxcmanptyycst")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The state the pipe should be in. One of: `RUNNING`, `STOPPED`.
     */
    @JvmName("gkxwraanyriistno")
    public suspend fun desiredState(`value`: Output<String>) {
        this.desiredState = value
    }

    /**
     * @param value Enrichment resource of the pipe (typically an ARN). Read more about enrichment in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-enrichment).
     */
    @JvmName("jpbxrqwakvpqmegg")
    public suspend fun enrichment(`value`: Output<String>) {
        this.enrichment = value
    }

    /**
     * @param value Parameters to configure enrichment for your pipe. Detailed below.
     */
    @JvmName("ffuweulvujjfkjoq")
    public suspend fun enrichmentParameters(`value`: Output<PipeEnrichmentParametersArgs>) {
        this.enrichmentParameters = value
    }

    /**
     * @param value Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("kyexhvqdqryhspnu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("wdclxqtjxexgwlma")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value ARN of the role that allows the pipe to send data to the target.
     */
    @JvmName("thuskvbgahyfjutg")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Source resource of the pipe (typically an ARN).
     */
    @JvmName("qutmtluowyfsgpry")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Parameters to configure a source for the pipe. Detailed below.
     */
    @JvmName("fxkrsuospbasuloo")
    public suspend fun sourceParameters(`value`: Output<PipeSourceParametersArgs>) {
        this.sourceParameters = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("twvokhhdxqgtfnfl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Target resource of the pipe (typically an ARN).
     * The following arguments are optional:
     */
    @JvmName("rhodywxygfrsgcov")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Parameters to configure a target for your pipe. Detailed below.
     */
    @JvmName("lmkjrmikiabpwvaw")
    public suspend fun targetParameters(`value`: Output<PipeTargetParametersArgs>) {
        this.targetParameters = value
    }

    /**
     * @param value A description of the pipe. At most 512 characters.
     */
    @JvmName("xxlfysaiwgtcwwib")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The state the pipe should be in. One of: `RUNNING`, `STOPPED`.
     */
    @JvmName("fluqblqgsspbrqgc")
    public suspend fun desiredState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredState = mapped
    }

    /**
     * @param value Enrichment resource of the pipe (typically an ARN). Read more about enrichment in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-enrichment).
     */
    @JvmName("whfalecxfclwweah")
    public suspend fun enrichment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enrichment = mapped
    }

    /**
     * @param value Parameters to configure enrichment for your pipe. Detailed below.
     */
    @JvmName("abokdojigxbycdei")
    public suspend fun enrichmentParameters(`value`: PipeEnrichmentParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enrichmentParameters = mapped
    }

    /**
     * @param argument Parameters to configure enrichment for your pipe. Detailed below.
     */
    @JvmName("tcblhewmbpfehiaj")
    public suspend
    fun enrichmentParameters(argument: suspend PipeEnrichmentParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeEnrichmentParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.enrichmentParameters = mapped
    }

    /**
     * @param value Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("yrfwhxuqcncugmei")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("ikodhmbkjhablrkb")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value ARN of the role that allows the pipe to send data to the target.
     */
    @JvmName("nkkoileitwkaqnce")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Source resource of the pipe (typically an ARN).
     */
    @JvmName("sbamybhnaybopkpq")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Parameters to configure a source for the pipe. Detailed below.
     */
    @JvmName("nyreylcoivabpemi")
    public suspend fun sourceParameters(`value`: PipeSourceParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceParameters = mapped
    }

    /**
     * @param argument Parameters to configure a source for the pipe. Detailed below.
     */
    @JvmName("kxsvybdfmrldvlcx")
    public suspend
    fun sourceParameters(argument: suspend PipeSourceParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeSourceParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceParameters = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wbmhrwvxkqmuvtgx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nebyexhpsmewadot")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Target resource of the pipe (typically an ARN).
     * The following arguments are optional:
     */
    @JvmName("jfwmttouakbglidk")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value Parameters to configure a target for your pipe. Detailed below.
     */
    @JvmName("bufrrahfoeefgyep")
    public suspend fun targetParameters(`value`: PipeTargetParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetParameters = mapped
    }

    /**
     * @param argument Parameters to configure a target for your pipe. Detailed below.
     */
    @JvmName("elriufrljntilgxt")
    public suspend
    fun targetParameters(argument: suspend PipeTargetParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeTargetParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetParameters = mapped
    }

    internal fun build(): PipeArgs = PipeArgs(
        description = description,
        desiredState = desiredState,
        enrichment = enrichment,
        enrichmentParameters = enrichmentParameters,
        name = name,
        namePrefix = namePrefix,
        roleArn = roleArn,
        source = source,
        sourceParameters = sourceParameters,
        tags = tags,
        target = target,
        targetParameters = targetParameters,
    )
}
