@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersActivemqBrokerParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property batchSize The maximum number of records to include in each batch. Maximum value of 10000.
 * @property credentials The credentials needed to access the resource. Detailed below.
 * @property maximumBatchingWindowInSeconds The maximum length of a time to wait for events. Maximum value of 300.
 * @property queueName The name of the destination queue to consume. Maximum length of 1000.
 */
public data class PipeSourceParametersActivemqBrokerParametersArgs(
    public val batchSize: Output<Int>? = null,
    public val credentials: Output<PipeSourceParametersActivemqBrokerParametersCredentialsArgs>,
    public val maximumBatchingWindowInSeconds: Output<Int>? = null,
    public val queueName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersActivemqBrokerParametersArgs> {
    override fun toJava():
        com.pulumi.aws.pipes.inputs.PipeSourceParametersActivemqBrokerParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersActivemqBrokerParametersArgs.builder()
            .batchSize(batchSize?.applyValue({ args0 -> args0 }))
            .credentials(credentials.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maximumBatchingWindowInSeconds(maximumBatchingWindowInSeconds?.applyValue({ args0 -> args0 }))
            .queueName(queueName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeSourceParametersActivemqBrokerParametersArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersActivemqBrokerParametersArgsBuilder internal constructor() {
    private var batchSize: Output<Int>? = null

    private var credentials: Output<PipeSourceParametersActivemqBrokerParametersCredentialsArgs>? =
        null

    private var maximumBatchingWindowInSeconds: Output<Int>? = null

    private var queueName: Output<String>? = null

    /**
     * @param value The maximum number of records to include in each batch. Maximum value of 10000.
     */
    @JvmName("piuvxgygoudymrox")
    public suspend fun batchSize(`value`: Output<Int>) {
        this.batchSize = value
    }

    /**
     * @param value The credentials needed to access the resource. Detailed below.
     */
    @JvmName("wuydntwdafwxomel")
    public suspend
    fun credentials(`value`: Output<PipeSourceParametersActivemqBrokerParametersCredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value The maximum length of a time to wait for events. Maximum value of 300.
     */
    @JvmName("wnfbougeephabuxf")
    public suspend fun maximumBatchingWindowInSeconds(`value`: Output<Int>) {
        this.maximumBatchingWindowInSeconds = value
    }

    /**
     * @param value The name of the destination queue to consume. Maximum length of 1000.
     */
    @JvmName("xcgxexvjnfwwpxhk")
    public suspend fun queueName(`value`: Output<String>) {
        this.queueName = value
    }

    /**
     * @param value The maximum number of records to include in each batch. Maximum value of 10000.
     */
    @JvmName("uohhyvncxieweubw")
    public suspend fun batchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value The credentials needed to access the resource. Detailed below.
     */
    @JvmName("agcshiiyoycslbgf")
    public suspend
    fun credentials(`value`: PipeSourceParametersActivemqBrokerParametersCredentialsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument The credentials needed to access the resource. Detailed below.
     */
    @JvmName("njmdoqccfjdoeogj")
    public suspend
    fun credentials(argument: suspend PipeSourceParametersActivemqBrokerParametersCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped =
            PipeSourceParametersActivemqBrokerParametersCredentialsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value The maximum length of a time to wait for events. Maximum value of 300.
     */
    @JvmName("tmwhyrisanjowwpo")
    public suspend fun maximumBatchingWindowInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumBatchingWindowInSeconds = mapped
    }

    /**
     * @param value The name of the destination queue to consume. Maximum length of 1000.
     */
    @JvmName("cnnsasgsfqugbrhy")
    public suspend fun queueName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queueName = mapped
    }

    internal fun build(): PipeSourceParametersActivemqBrokerParametersArgs =
        PipeSourceParametersActivemqBrokerParametersArgs(
            batchSize = batchSize,
            credentials = credentials ?: throw PulumiNullFieldException("credentials"),
            maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds,
            queueName = queueName ?: throw PulumiNullFieldException("queueName"),
        )
}
