@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersDynamodbStreamParametersDeadLetterConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn The ARN of the Amazon SQS queue specified as the target for the dead-letter queue.
 */
public data class PipeSourceParametersDynamodbStreamParametersDeadLetterConfigArgs(
    public val arn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersDynamodbStreamParametersDeadLetterConfigArgs> {
    override fun toJava():
        com.pulumi.aws.pipes.inputs.PipeSourceParametersDynamodbStreamParametersDeadLetterConfigArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersDynamodbStreamParametersDeadLetterConfigArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeSourceParametersDynamodbStreamParametersDeadLetterConfigArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersDynamodbStreamParametersDeadLetterConfigArgsBuilder internal
constructor() {
    private var arn: Output<String>? = null

    /**
     * @param value The ARN of the Amazon SQS queue specified as the target for the dead-letter queue.
     */
    @JvmName("lcvvatkwxjjtvdao")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The ARN of the Amazon SQS queue specified as the target for the dead-letter queue.
     */
    @JvmName("koxadsinaboxjsch")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    internal fun build(): PipeSourceParametersDynamodbStreamParametersDeadLetterConfigArgs =
        PipeSourceParametersDynamodbStreamParametersDeadLetterConfigArgs(
            arn = arn,
        )
}
