@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersFilterCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property filters An array of up to 5 event patterns. Detailed below.
 */
public data class PipeSourceParametersFilterCriteriaArgs(
    public val filters: Output<List<PipeSourceParametersFilterCriteriaFilterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersFilterCriteriaArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeSourceParametersFilterCriteriaArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersFilterCriteriaArgs.builder()
            .filters(
                filters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PipeSourceParametersFilterCriteriaArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersFilterCriteriaArgsBuilder internal constructor() {
    private var filters: Output<List<PipeSourceParametersFilterCriteriaFilterArgs>>? = null

    /**
     * @param value An array of up to 5 event patterns. Detailed below.
     */
    @JvmName("dwmlxyueiitmwfou")
    public suspend fun filters(`value`: Output<List<PipeSourceParametersFilterCriteriaFilterArgs>>) {
        this.filters = value
    }

    @JvmName("xnmxjwmhisixujem")
    public suspend fun filters(vararg values: Output<PipeSourceParametersFilterCriteriaFilterArgs>) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values An array of up to 5 event patterns. Detailed below.
     */
    @JvmName("fhomissjpwfrwwlj")
    public suspend fun filters(values: List<Output<PipeSourceParametersFilterCriteriaFilterArgs>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value An array of up to 5 event patterns. Detailed below.
     */
    @JvmName("byhfsmiveyssldvf")
    public suspend fun filters(`value`: List<PipeSourceParametersFilterCriteriaFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument An array of up to 5 event patterns. Detailed below.
     */
    @JvmName("orlawwxwagslesia")
    public suspend
    fun filters(argument: List<suspend PipeSourceParametersFilterCriteriaFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeSourceParametersFilterCriteriaFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument An array of up to 5 event patterns. Detailed below.
     */
    @JvmName("hlhouqhacvmpadhi")
    public suspend fun filters(
        vararg
        argument: suspend PipeSourceParametersFilterCriteriaFilterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PipeSourceParametersFilterCriteriaFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument An array of up to 5 event patterns. Detailed below.
     */
    @JvmName("fppgkmumysaellrm")
    public suspend
    fun filters(argument: suspend PipeSourceParametersFilterCriteriaFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PipeSourceParametersFilterCriteriaFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param values An array of up to 5 event patterns. Detailed below.
     */
    @JvmName("xmqbbjxuxfgijoeu")
    public suspend fun filters(vararg values: PipeSourceParametersFilterCriteriaFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    internal fun build(): PipeSourceParametersFilterCriteriaArgs =
        PipeSourceParametersFilterCriteriaArgs(
            filters = filters,
        )
}
