@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersKinesisStreamParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property batchSize The maximum number of records to include in each batch. Maximum value of 10000.
 * @property deadLetterConfig Define the target queue to send dead-letter queue events to. Detailed below.
 * @property maximumBatchingWindowInSeconds The maximum length of a time to wait for events. Maximum value of 300.
 * @property maximumRecordAgeInSeconds Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records. Maximum value of 604,800.
 * @property maximumRetryAttempts Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source. Maximum value of 10,000.
 * @property onPartialBatchItemFailure Define how to handle item process failures. AUTOMATIC_BISECT halves each batch and retry each half until all the records are processed or there is one failed message left in the batch. Valid values: AUTOMATIC_BISECT.
 * @property parallelizationFactor The number of batches to process concurrently from each shard. The default value is 1. Maximum value of 10.
 * @property startingPosition The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
 * @property startingPositionTimestamp With StartingPosition set to AT_TIMESTAMP, the time from which to start reading, in Unix time seconds.
 */
public data class PipeSourceParametersKinesisStreamParametersArgs(
    public val batchSize: Output<Int>? = null,
    public val deadLetterConfig:
    Output<PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgs>? = null,
    public val maximumBatchingWindowInSeconds: Output<Int>? = null,
    public val maximumRecordAgeInSeconds: Output<Int>? = null,
    public val maximumRetryAttempts: Output<Int>? = null,
    public val onPartialBatchItemFailure: Output<String>? = null,
    public val parallelizationFactor: Output<Int>? = null,
    public val startingPosition: Output<String>,
    public val startingPositionTimestamp: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersKinesisStreamParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeSourceParametersKinesisStreamParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersKinesisStreamParametersArgs.builder()
            .batchSize(batchSize?.applyValue({ args0 -> args0 }))
            .deadLetterConfig(deadLetterConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maximumBatchingWindowInSeconds(maximumBatchingWindowInSeconds?.applyValue({ args0 -> args0 }))
            .maximumRecordAgeInSeconds(maximumRecordAgeInSeconds?.applyValue({ args0 -> args0 }))
            .maximumRetryAttempts(maximumRetryAttempts?.applyValue({ args0 -> args0 }))
            .onPartialBatchItemFailure(onPartialBatchItemFailure?.applyValue({ args0 -> args0 }))
            .parallelizationFactor(parallelizationFactor?.applyValue({ args0 -> args0 }))
            .startingPosition(startingPosition.applyValue({ args0 -> args0 }))
            .startingPositionTimestamp(startingPositionTimestamp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeSourceParametersKinesisStreamParametersArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersKinesisStreamParametersArgsBuilder internal constructor() {
    private var batchSize: Output<Int>? = null

    private var deadLetterConfig:
        Output<PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgs>? = null

    private var maximumBatchingWindowInSeconds: Output<Int>? = null

    private var maximumRecordAgeInSeconds: Output<Int>? = null

    private var maximumRetryAttempts: Output<Int>? = null

    private var onPartialBatchItemFailure: Output<String>? = null

    private var parallelizationFactor: Output<Int>? = null

    private var startingPosition: Output<String>? = null

    private var startingPositionTimestamp: Output<String>? = null

    /**
     * @param value The maximum number of records to include in each batch. Maximum value of 10000.
     */
    @JvmName("vmbydnxoqcapxifa")
    public suspend fun batchSize(`value`: Output<Int>) {
        this.batchSize = value
    }

    /**
     * @param value Define the target queue to send dead-letter queue events to. Detailed below.
     */
    @JvmName("doigrbdippwoirvb")
    public suspend
    fun deadLetterConfig(`value`: Output<PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgs>) {
        this.deadLetterConfig = value
    }

    /**
     * @param value The maximum length of a time to wait for events. Maximum value of 300.
     */
    @JvmName("prluhnsjjmaqunbc")
    public suspend fun maximumBatchingWindowInSeconds(`value`: Output<Int>) {
        this.maximumBatchingWindowInSeconds = value
    }

    /**
     * @param value Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records. Maximum value of 604,800.
     */
    @JvmName("bpvthmfwuphpbowg")
    public suspend fun maximumRecordAgeInSeconds(`value`: Output<Int>) {
        this.maximumRecordAgeInSeconds = value
    }

    /**
     * @param value Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source. Maximum value of 10,000.
     */
    @JvmName("emrfaxqyqypcnqjm")
    public suspend fun maximumRetryAttempts(`value`: Output<Int>) {
        this.maximumRetryAttempts = value
    }

    /**
     * @param value Define how to handle item process failures. AUTOMATIC_BISECT halves each batch and retry each half until all the records are processed or there is one failed message left in the batch. Valid values: AUTOMATIC_BISECT.
     */
    @JvmName("rrkvgnxcfvyxuxhk")
    public suspend fun onPartialBatchItemFailure(`value`: Output<String>) {
        this.onPartialBatchItemFailure = value
    }

    /**
     * @param value The number of batches to process concurrently from each shard. The default value is 1. Maximum value of 10.
     */
    @JvmName("hguyjdxysistpujs")
    public suspend fun parallelizationFactor(`value`: Output<Int>) {
        this.parallelizationFactor = value
    }

    /**
     * @param value The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
     */
    @JvmName("abocwakkgqgxdxyg")
    public suspend fun startingPosition(`value`: Output<String>) {
        this.startingPosition = value
    }

    /**
     * @param value With StartingPosition set to AT_TIMESTAMP, the time from which to start reading, in Unix time seconds.
     */
    @JvmName("gfjxfnjtbbcadntb")
    public suspend fun startingPositionTimestamp(`value`: Output<String>) {
        this.startingPositionTimestamp = value
    }

    /**
     * @param value The maximum number of records to include in each batch. Maximum value of 10000.
     */
    @JvmName("nmwjeibtsxwgkxas")
    public suspend fun batchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value Define the target queue to send dead-letter queue events to. Detailed below.
     */
    @JvmName("plxtfpamwyrkbvre")
    public suspend
    fun deadLetterConfig(`value`: PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterConfig = mapped
    }

    /**
     * @param argument Define the target queue to send dead-letter queue events to. Detailed below.
     */
    @JvmName("mbugxjdjcgysyemw")
    public suspend
    fun deadLetterConfig(argument: suspend PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.deadLetterConfig = mapped
    }

    /**
     * @param value The maximum length of a time to wait for events. Maximum value of 300.
     */
    @JvmName("fafjwxjedqkpbdpa")
    public suspend fun maximumBatchingWindowInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumBatchingWindowInSeconds = mapped
    }

    /**
     * @param value Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records. Maximum value of 604,800.
     */
    @JvmName("eiexiurywsmivgya")
    public suspend fun maximumRecordAgeInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumRecordAgeInSeconds = mapped
    }

    /**
     * @param value Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source. Maximum value of 10,000.
     */
    @JvmName("pukjtlpqsexkyxmp")
    public suspend fun maximumRetryAttempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumRetryAttempts = mapped
    }

    /**
     * @param value Define how to handle item process failures. AUTOMATIC_BISECT halves each batch and retry each half until all the records are processed or there is one failed message left in the batch. Valid values: AUTOMATIC_BISECT.
     */
    @JvmName("lqcfmrxeuqixpfll")
    public suspend fun onPartialBatchItemFailure(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onPartialBatchItemFailure = mapped
    }

    /**
     * @param value The number of batches to process concurrently from each shard. The default value is 1. Maximum value of 10.
     */
    @JvmName("ojkfdgftiyhantos")
    public suspend fun parallelizationFactor(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelizationFactor = mapped
    }

    /**
     * @param value The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
     */
    @JvmName("yeacdmlpgijgsahk")
    public suspend fun startingPosition(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startingPosition = mapped
    }

    /**
     * @param value With StartingPosition set to AT_TIMESTAMP, the time from which to start reading, in Unix time seconds.
     */
    @JvmName("ibmvekykguxbrtbp")
    public suspend fun startingPositionTimestamp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startingPositionTimestamp = mapped
    }

    internal fun build(): PipeSourceParametersKinesisStreamParametersArgs =
        PipeSourceParametersKinesisStreamParametersArgs(
            batchSize = batchSize,
            deadLetterConfig = deadLetterConfig,
            maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds,
            maximumRecordAgeInSeconds = maximumRecordAgeInSeconds,
            maximumRetryAttempts = maximumRetryAttempts,
            onPartialBatchItemFailure = onPartialBatchItemFailure,
            parallelizationFactor = parallelizationFactor,
            startingPosition = startingPosition ?: throw PulumiNullFieldException("startingPosition"),
            startingPositionTimestamp = startingPositionTimestamp,
        )
}
