@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersRabbitmqBrokerParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property batchSize The maximum number of records to include in each batch. Maximum value of 10000.
 * @property credentials The credentials needed to access the resource. Detailed below.
 * @property maximumBatchingWindowInSeconds The maximum length of a time to wait for events. Maximum value of 300.
 * @property queueName The name of the destination queue to consume. Maximum length of 1000.
 * @property virtualHost The name of the virtual host associated with the source broker. Maximum length of 200.
 */
public data class PipeSourceParametersRabbitmqBrokerParametersArgs(
    public val batchSize: Output<Int>? = null,
    public val credentials: Output<PipeSourceParametersRabbitmqBrokerParametersCredentialsArgs>,
    public val maximumBatchingWindowInSeconds: Output<Int>? = null,
    public val queueName: Output<String>,
    public val virtualHost: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersRabbitmqBrokerParametersArgs> {
    override fun toJava():
        com.pulumi.aws.pipes.inputs.PipeSourceParametersRabbitmqBrokerParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersRabbitmqBrokerParametersArgs.builder()
            .batchSize(batchSize?.applyValue({ args0 -> args0 }))
            .credentials(credentials.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maximumBatchingWindowInSeconds(maximumBatchingWindowInSeconds?.applyValue({ args0 -> args0 }))
            .queueName(queueName.applyValue({ args0 -> args0 }))
            .virtualHost(virtualHost?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeSourceParametersRabbitmqBrokerParametersArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersRabbitmqBrokerParametersArgsBuilder internal constructor() {
    private var batchSize: Output<Int>? = null

    private var credentials: Output<PipeSourceParametersRabbitmqBrokerParametersCredentialsArgs>? =
        null

    private var maximumBatchingWindowInSeconds: Output<Int>? = null

    private var queueName: Output<String>? = null

    private var virtualHost: Output<String>? = null

    /**
     * @param value The maximum number of records to include in each batch. Maximum value of 10000.
     */
    @JvmName("mpdhimftmlcefpkb")
    public suspend fun batchSize(`value`: Output<Int>) {
        this.batchSize = value
    }

    /**
     * @param value The credentials needed to access the resource. Detailed below.
     */
    @JvmName("yrdwvtxovyniwpcm")
    public suspend
    fun credentials(`value`: Output<PipeSourceParametersRabbitmqBrokerParametersCredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value The maximum length of a time to wait for events. Maximum value of 300.
     */
    @JvmName("temyevsaialeqtmy")
    public suspend fun maximumBatchingWindowInSeconds(`value`: Output<Int>) {
        this.maximumBatchingWindowInSeconds = value
    }

    /**
     * @param value The name of the destination queue to consume. Maximum length of 1000.
     */
    @JvmName("kewwvlxeopghmddi")
    public suspend fun queueName(`value`: Output<String>) {
        this.queueName = value
    }

    /**
     * @param value The name of the virtual host associated with the source broker. Maximum length of 200.
     */
    @JvmName("putcwolrxtycjrne")
    public suspend fun virtualHost(`value`: Output<String>) {
        this.virtualHost = value
    }

    /**
     * @param value The maximum number of records to include in each batch. Maximum value of 10000.
     */
    @JvmName("cdswkoxfmjwhieub")
    public suspend fun batchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value The credentials needed to access the resource. Detailed below.
     */
    @JvmName("qlgrwbixoonndvyo")
    public suspend
    fun credentials(`value`: PipeSourceParametersRabbitmqBrokerParametersCredentialsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument The credentials needed to access the resource. Detailed below.
     */
    @JvmName("etrdmwcfgklrbkri")
    public suspend
    fun credentials(argument: suspend PipeSourceParametersRabbitmqBrokerParametersCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped =
            PipeSourceParametersRabbitmqBrokerParametersCredentialsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value The maximum length of a time to wait for events. Maximum value of 300.
     */
    @JvmName("akqatplnnkgrbpek")
    public suspend fun maximumBatchingWindowInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumBatchingWindowInSeconds = mapped
    }

    /**
     * @param value The name of the destination queue to consume. Maximum length of 1000.
     */
    @JvmName("yxosjydywkpjpmhb")
    public suspend fun queueName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queueName = mapped
    }

    /**
     * @param value The name of the virtual host associated with the source broker. Maximum length of 200.
     */
    @JvmName("tywfbnetbyvjjfoq")
    public suspend fun virtualHost(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHost = mapped
    }

    internal fun build(): PipeSourceParametersRabbitmqBrokerParametersArgs =
        PipeSourceParametersRabbitmqBrokerParametersArgs(
            batchSize = batchSize,
            credentials = credentials ?: throw PulumiNullFieldException("credentials"),
            maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds,
            queueName = queueName ?: throw PulumiNullFieldException("queueName"),
            virtualHost = virtualHost,
        )
}
