@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property additionalBootstrapServers An array of server URLs. Maximum number of 2 items, each of maximum length 300.
 * @property batchSize The maximum number of records to include in each batch. Maximum value of 10000.
 * @property consumerGroupId The name of the destination queue to consume. Maximum value of 200.
 * @property credentials The credentials needed to access the resource. Detailed below.
 * @property maximumBatchingWindowInSeconds The maximum length of a time to wait for events. Maximum value of 300.
 * @property serverRootCaCertificate The ARN of the Secrets Manager secret used for certification.
 * @property startingPosition The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
 * @property topicName The name of the topic that the pipe will read from. Maximum length of 249.
 * @property vpc This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used. Detailed below.
 */
public data class PipeSourceParametersSelfManagedKafkaParametersArgs(
    public val additionalBootstrapServers: Output<List<String>>? = null,
    public val batchSize: Output<Int>? = null,
    public val consumerGroupId: Output<String>? = null,
    public val credentials: Output<PipeSourceParametersSelfManagedKafkaParametersCredentialsArgs>? =
        null,
    public val maximumBatchingWindowInSeconds: Output<Int>? = null,
    public val serverRootCaCertificate: Output<String>? = null,
    public val startingPosition: Output<String>? = null,
    public val topicName: Output<String>,
    public val vpc: Output<PipeSourceParametersSelfManagedKafkaParametersVpcArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersArgs> {
    override fun toJava():
        com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersArgs.builder()
            .additionalBootstrapServers(
                additionalBootstrapServers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .batchSize(batchSize?.applyValue({ args0 -> args0 }))
            .consumerGroupId(consumerGroupId?.applyValue({ args0 -> args0 }))
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maximumBatchingWindowInSeconds(maximumBatchingWindowInSeconds?.applyValue({ args0 -> args0 }))
            .serverRootCaCertificate(serverRootCaCertificate?.applyValue({ args0 -> args0 }))
            .startingPosition(startingPosition?.applyValue({ args0 -> args0 }))
            .topicName(topicName.applyValue({ args0 -> args0 }))
            .vpc(vpc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PipeSourceParametersSelfManagedKafkaParametersArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersSelfManagedKafkaParametersArgsBuilder internal constructor() {
    private var additionalBootstrapServers: Output<List<String>>? = null

    private var batchSize: Output<Int>? = null

    private var consumerGroupId: Output<String>? = null

    private var credentials: Output<PipeSourceParametersSelfManagedKafkaParametersCredentialsArgs>? =
        null

    private var maximumBatchingWindowInSeconds: Output<Int>? = null

    private var serverRootCaCertificate: Output<String>? = null

    private var startingPosition: Output<String>? = null

    private var topicName: Output<String>? = null

    private var vpc: Output<PipeSourceParametersSelfManagedKafkaParametersVpcArgs>? = null

    /**
     * @param value An array of server URLs. Maximum number of 2 items, each of maximum length 300.
     */
    @JvmName("gegablqlksvlhcmb")
    public suspend fun additionalBootstrapServers(`value`: Output<List<String>>) {
        this.additionalBootstrapServers = value
    }

    @JvmName("uqgqafkwxkrmkadb")
    public suspend fun additionalBootstrapServers(vararg values: Output<String>) {
        this.additionalBootstrapServers = Output.all(values.asList())
    }

    /**
     * @param values An array of server URLs. Maximum number of 2 items, each of maximum length 300.
     */
    @JvmName("cjgnmkmixnjregul")
    public suspend fun additionalBootstrapServers(values: List<Output<String>>) {
        this.additionalBootstrapServers = Output.all(values)
    }

    /**
     * @param value The maximum number of records to include in each batch. Maximum value of 10000.
     */
    @JvmName("chyjfbsoaxmdarfa")
    public suspend fun batchSize(`value`: Output<Int>) {
        this.batchSize = value
    }

    /**
     * @param value The name of the destination queue to consume. Maximum value of 200.
     */
    @JvmName("bdqsevyjngxtqgfp")
    public suspend fun consumerGroupId(`value`: Output<String>) {
        this.consumerGroupId = value
    }

    /**
     * @param value The credentials needed to access the resource. Detailed below.
     */
    @JvmName("hqaxcxtdqrfurbnc")
    public suspend
    fun credentials(`value`: Output<PipeSourceParametersSelfManagedKafkaParametersCredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value The maximum length of a time to wait for events. Maximum value of 300.
     */
    @JvmName("ajrgpqiwmhrfycyq")
    public suspend fun maximumBatchingWindowInSeconds(`value`: Output<Int>) {
        this.maximumBatchingWindowInSeconds = value
    }

    /**
     * @param value The ARN of the Secrets Manager secret used for certification.
     */
    @JvmName("fbsqiuwhsfptypdf")
    public suspend fun serverRootCaCertificate(`value`: Output<String>) {
        this.serverRootCaCertificate = value
    }

    /**
     * @param value The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
     */
    @JvmName("wkxwmpwplltffion")
    public suspend fun startingPosition(`value`: Output<String>) {
        this.startingPosition = value
    }

    /**
     * @param value The name of the topic that the pipe will read from. Maximum length of 249.
     */
    @JvmName("tpovqkmwvuahqerh")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used. Detailed below.
     */
    @JvmName("neltyjjeunxfvknk")
    public suspend fun vpc(`value`: Output<PipeSourceParametersSelfManagedKafkaParametersVpcArgs>) {
        this.vpc = value
    }

    /**
     * @param value An array of server URLs. Maximum number of 2 items, each of maximum length 300.
     */
    @JvmName("hjyrhaftfsrmwisr")
    public suspend fun additionalBootstrapServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalBootstrapServers = mapped
    }

    /**
     * @param values An array of server URLs. Maximum number of 2 items, each of maximum length 300.
     */
    @JvmName("bkmnpkvclgyqtfqq")
    public suspend fun additionalBootstrapServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalBootstrapServers = mapped
    }

    /**
     * @param value The maximum number of records to include in each batch. Maximum value of 10000.
     */
    @JvmName("ghpwncthokpjpvun")
    public suspend fun batchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value The name of the destination queue to consume. Maximum value of 200.
     */
    @JvmName("hxskrqkkjrngojif")
    public suspend fun consumerGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroupId = mapped
    }

    /**
     * @param value The credentials needed to access the resource. Detailed below.
     */
    @JvmName("uercghrprqmyyvva")
    public suspend
    fun credentials(`value`: PipeSourceParametersSelfManagedKafkaParametersCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument The credentials needed to access the resource. Detailed below.
     */
    @JvmName("vfuivxesgemdbhil")
    public suspend
    fun credentials(argument: suspend PipeSourceParametersSelfManagedKafkaParametersCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped =
            PipeSourceParametersSelfManagedKafkaParametersCredentialsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value The maximum length of a time to wait for events. Maximum value of 300.
     */
    @JvmName("qhwdhhmqvqwyjqxm")
    public suspend fun maximumBatchingWindowInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumBatchingWindowInSeconds = mapped
    }

    /**
     * @param value The ARN of the Secrets Manager secret used for certification.
     */
    @JvmName("gmxftrejovphddhe")
    public suspend fun serverRootCaCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverRootCaCertificate = mapped
    }

    /**
     * @param value The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
     */
    @JvmName("acvuwwsavicaycre")
    public suspend fun startingPosition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startingPosition = mapped
    }

    /**
     * @param value The name of the topic that the pipe will read from. Maximum length of 249.
     */
    @JvmName("mlnwlrfhemgdgqsl")
    public suspend fun topicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    /**
     * @param value This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used. Detailed below.
     */
    @JvmName("bqqebaumlgyywqen")
    public suspend fun vpc(`value`: PipeSourceParametersSelfManagedKafkaParametersVpcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpc = mapped
    }

    /**
     * @param argument This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used. Detailed below.
     */
    @JvmName("vnroglxotbqrprdb")
    public suspend
    fun vpc(argument: suspend PipeSourceParametersSelfManagedKafkaParametersVpcArgsBuilder.() -> Unit) {
        val toBeMapped = PipeSourceParametersSelfManagedKafkaParametersVpcArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vpc = mapped
    }

    internal fun build(): PipeSourceParametersSelfManagedKafkaParametersArgs =
        PipeSourceParametersSelfManagedKafkaParametersArgs(
            additionalBootstrapServers = additionalBootstrapServers,
            batchSize = batchSize,
            consumerGroupId = consumerGroupId,
            credentials = credentials,
            maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds,
            serverRootCaCertificate = serverRootCaCertificate,
            startingPosition = startingPosition,
            topicName = topicName ?: throw PulumiNullFieldException("topicName"),
            vpc = vpc,
        )
}
